/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;

public class TransactionalBatch<E extends RuntimeException>
implements TransactionBatch {
    private final Logger logger;
    private final Function<Throwable, E> exceptionTransformer;
    private final Transaction tx;
    private final AtomicInteger count = new AtomicInteger(0);
    private volatile boolean active = true;

    public TransactionalBatch(Transaction tx, Logger logger, Function<Throwable, E> exceptionTransformer) {
        this.tx = tx;
        this.logger = logger;
        this.exceptionTransformer = exceptionTransformer;
        this.logger.debugf("Started batch %s[%d]", (Object)this.tx, (Object)this.count.get());
    }

    @Override
    public Transaction getTransaction() {
        return this.tx;
    }

    @Override
    public TransactionBatch interpose() {
        int count = this.count.incrementAndGet();
        this.logger.debugf("Interposed batch %s[%d]", (Object)this.tx, (Object)count);
        return this;
    }

    public void discard() {
        this.active = false;
    }

    public Batch.State getState() {
        try {
            switch (this.tx.getStatus()) {
                case 0: {
                    if (this.active) {
                        return Batch.State.ACTIVE;
                    }
                }
                case 1: {
                    return Batch.State.DISCARDED;
                }
            }
            return Batch.State.CLOSED;
        }
        catch (SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public void close() {
        int count = this.count.getAndDecrement();
        if (count == 0) {
            try {
                switch (this.tx.getStatus()) {
                    case 0: {
                        if (this.active) {
                            try {
                                this.logger.debugf("Committing batch %s[%d]", (Object)this.tx, (Object)count);
                                this.tx.commit();
                                break;
                            }
                            catch (RollbackException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (HeuristicMixedException | HeuristicRollbackException e) {
                                throw (RuntimeException)this.exceptionTransformer.apply(e);
                            }
                        }
                    }
                    case 1: {
                        this.logger.debugf("Rolling back batch %s[%d]", (Object)this.tx, (Object)count);
                        this.tx.rollback();
                        break;
                    }
                    default: {
                        this.logger.debugf("Closed batch %s[%d] with status = %d", (Object)this.tx, (Object)count, (Object)this.tx.getStatus());
                        break;
                    }
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)this.exceptionTransformer.apply(e);
            }
        } else {
            this.logger.debugf("Closed interposed batch %s[%d]", (Object)this.tx, (Object)count);
        }
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionalBatch)) {
            return false;
        }
        TransactionalBatch batch = (TransactionalBatch)object;
        return this.tx.equals((Object)batch.tx);
    }

    public String toString() {
        return String.format("%s[%d]", this.tx, this.count.get());
    }
}

