/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.BatchContext;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionBatch;

public class ThreadLocalTransactionBatch<E extends RuntimeException>
implements TransactionBatch {
    private static final Batch NOOP_BATCH = (Batch)Batch.factory().get();
    private static final ThreadLocal<TransactionBatch> CURRENT_BATCH = new ThreadLocal();
    private final TransactionManager tm;
    private final Transaction tx;
    private final System.Logger logger;
    private final Function<Throwable, E> exceptionTransformer;
    private final AtomicInteger count = new AtomicInteger(0);
    private volatile boolean active = true;

    static TransactionBatch getCurrentBatch() {
        return CURRENT_BATCH.get();
    }

    static void setCurrentBatch(TransactionBatch batch) {
        if (batch != null) {
            CURRENT_BATCH.set(batch);
        } else {
            CURRENT_BATCH.remove();
        }
    }

    ThreadLocalTransactionBatch(TransactionManager tm, Transaction tx, System.Logger logger, Function<Throwable, E> exceptionTransformer) {
        this.tm = tm;
        this.tx = tx;
        this.logger = logger;
        this.exceptionTransformer = exceptionTransformer;
        this.logger.log(System.Logger.Level.DEBUG, "Started batch {0}[{1}]", this.tx, this.count.get());
    }

    private int getStatus() {
        try {
            return this.tx.getStatus();
        }
        catch (SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
    }

    public boolean isActive() {
        int status = this.getStatus();
        return status == 0 && this.active;
    }

    public boolean isDiscarding() {
        int status = this.getStatus();
        return status == 0 && !this.active || status == 1;
    }

    public boolean isClosed() {
        int status = this.getStatus();
        return status != 0 && status != 1;
    }

    public SuspendedBatch suspend() {
        TransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
        if (batch == null) {
            return NOOP_BATCH.suspend();
        }
        if (batch != this) {
            return this;
        }
        try {
            Transaction suspendedTx = this.tm.suspend();
            if (suspendedTx != this.tx) {
                throw new IllegalStateException();
            }
        }
        catch (SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
        ThreadLocalTransactionBatch.setCurrentBatch(null);
        return this;
    }

    public Batch resume() {
        TransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
        if (batch == this) {
            return this;
        }
        if (batch != null) {
            batch.suspend();
        }
        if (this.isClosed()) {
            return NOOP_BATCH;
        }
        try {
            this.tm.resume(this.tx);
        }
        catch (InvalidTransactionException | SystemException e) {
            throw (RuntimeException)this.exceptionTransformer.apply(e);
        }
        ThreadLocalTransactionBatch.setCurrentBatch(this);
        return this;
    }

    public BatchContext<Batch> resumeWithContext() {
        final TransactionBatch batch = ThreadLocalTransactionBatch.getCurrentBatch();
        if (batch == this) {
            return new BatchContext<Batch>(){

                public Batch get() {
                    return batch;
                }

                public void close() {
                }
            };
        }
        final Batch resumed = this.resume();
        return new BatchContext<Batch>(){

            public Batch get() {
                return resumed;
            }

            public void close() {
                resumed.suspend();
                if (batch != null) {
                    batch.resume();
                }
            }
        };
    }

    @Override
    public Transaction getTransaction() {
        return this.tx;
    }

    @Override
    public TransactionBatch interpose() {
        if (ThreadLocalTransactionBatch.getCurrentBatch() != this) {
            throw new IllegalStateException();
        }
        int count = this.count.incrementAndGet();
        this.logger.log(System.Logger.Level.DEBUG, "Interposed batch {0}[{1}]", this.tx, count);
        return this;
    }

    public void discard() {
        if (ThreadLocalTransactionBatch.getCurrentBatch() != this) {
            throw new IllegalStateException();
        }
        this.active = false;
    }

    public void close() {
        if (ThreadLocalTransactionBatch.getCurrentBatch() != this) {
            throw new IllegalStateException();
        }
        int count = this.count.getAndDecrement();
        if (count == 0) {
            try {
                switch (this.tx.getStatus()) {
                    case 0: {
                        if (this.active) {
                            try {
                                this.logger.log(System.Logger.Level.DEBUG, "Committing batch {0}[{1}]", this.tx, count);
                                this.tx.commit();
                                break;
                            }
                            catch (RollbackException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (HeuristicMixedException | HeuristicRollbackException e) {
                                throw (RuntimeException)this.exceptionTransformer.apply(e);
                            }
                        }
                    }
                    case 1: {
                        this.logger.log(System.Logger.Level.DEBUG, "Rolling back batch {0}[{1}]", this.tx, count);
                        this.tx.rollback();
                        break;
                    }
                    default: {
                        this.logger.log(System.Logger.Level.DEBUG, "Closed batch {0}[{1}] with status = {2}", this.tx, count, this.tx.getStatus());
                        break;
                    }
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)this.exceptionTransformer.apply(e);
            }
        } else {
            this.logger.log(System.Logger.Level.DEBUG, "Closed interposed batch {0}[{1}]", this.tx, count);
        }
    }

    public int hashCode() {
        return this.tx.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ThreadLocalTransactionBatch)) {
            return false;
        }
        ThreadLocalTransactionBatch batch = (ThreadLocalTransactionBatch)object;
        return this.tx.equals((Object)batch.tx);
    }

    public String toString() {
        return String.format("%s[%d]", this.tx, this.count.get());
    }
}

