/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.cache.infinispan.batch.ContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ThreadContextBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatchFactory;
import org.wildfly.clustering.function.Supplier;

public class TransactionBatchTestCase {
    private final TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final Supplier<Batch> factory = new TransactionalBatchFactory("test", this.tm, RuntimeException::new);

    @AfterEach
    public void destroy() {
        ThreadContextBatch.INSTANCE.accept(null);
    }

    @BeforeEach
    public void init() {
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    @Test
    public void nestedBatch() throws Exception {
        TransactionalBatch existingBatch = (TransactionalBatch)Mockito.mock(TransactionalBatch.class);
        ThreadContextBatch.INSTANCE.accept((ContextualBatch)existingBatch);
        Batch result = (Batch)this.factory.get();
        ((TransactionalBatch)Mockito.verify((Object)existingBatch, (VerificationMode)Mockito.only())).get();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)result).isSameAs((Object)ThreadContextBatch.INSTANCE);
    }

    @Test
    public void illegalCurrentTransaction() throws Exception {
        Transaction existingTx = (Transaction)Mockito.mock(Transaction.class);
        ((TransactionManager)Mockito.doReturn((Object)existingTx).when((Object)this.tm)).getTransaction();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.factory.get());
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.only())).getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void close() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        try (Batch batch = (Batch)this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertThat((Object)batch).isSameAs((Object)ThreadContextBatch.INSTANCE);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 3}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(3);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)3))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void discard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        try (Batch batch = (Batch)this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertThat((Object)batch).isSameAs((Object)ThreadContextBatch.INSTANCE);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            batch.discard();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 4}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(4);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)3))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeNested() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        try (Batch outerBatch = (Batch)this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)outerBatch);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (Batch innerBatch = (Batch)this.factory.get();){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                ((Transaction)Mockito.verify((Object)tx)).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)innerBatch);
                Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)2))).getStatus();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 3}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(3);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)5))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void discardNestedInner() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        try (Batch outerBatch = (Batch)this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)outerBatch);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (Batch innerBatch = (Batch)this.factory.get();){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                ((Transaction)Mockito.verify((Object)tx)).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)innerBatch);
                Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
                innerBatch.discard();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)2))).getStatus();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 4}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(4);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)5))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void discardNestedOuter() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        try (Batch outerBatch = (Batch)this.factory.get();){
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)outerBatch);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            outerBatch.discard();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (Batch innerBatch = (Batch)this.factory.get();){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                ((Transaction)Mockito.verify((Object)tx)).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)innerBatch);
                Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            }
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)2))).getStatus();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 4}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(4);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)5))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void closeOverlapping() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        Batch batch1 = (Batch)this.factory.get();
        try {
            Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch1);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (Batch batch2 = (Batch)this.factory.get();){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                ((Transaction)Mockito.verify((Object)tx)).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch2);
                Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
                batch1.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)2))).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            }
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{3}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(3);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)5))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void discardOverlapping() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        Batch batch1 = (Batch)this.factory.get();
        try {
            Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch1);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
            ((Transaction)Mockito.doReturn((Object)0).when((Object)tx)).getStatus();
            try (Batch batch2 = (Batch)this.factory.get();){
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                ((Transaction)Mockito.verify((Object)tx)).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch2);
                Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
                batch2.discard();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                batch1.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)2))).getStatus();
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            }
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 4}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(4);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)5))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void suspendClosed() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        Batch batch = (Batch)this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch);
        Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
        ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 3}).when((Object)tx)).getStatus();
        try {
            batch.close();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(3);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)3))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        this.validateDisassociated(tx);
    }

    private void validateDisassociated(Transaction tx) {
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        SuspendedBatch suspend = ThreadContextBatch.INSTANCE.suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        Batch resumed = suspend.resume();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)resumed);
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        ThreadContextBatch.INSTANCE.discard();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        ThreadContextBatch.INSTANCE.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        Batch.Status status = ThreadContextBatch.INSTANCE.getStatus();
        Assertions.assertThat((Object)status).isNotNull();
        Assertions.assertThat((boolean)status.isActive()).isFalse();
        Assertions.assertThat((boolean)status.isDiscarding()).isFalse();
        Assertions.assertThat((boolean)status.isClosed()).isTrue();
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }

    @Test
    public void suspendResume() throws Exception {
        ArgumentCaptor sync = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        Batch batch = (Batch)this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)sync.capture());
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch);
        Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).suspend();
        SuspendedBatch suspended = batch.suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        this.validateDisassociated(tx);
        Batch resumed = suspended.resume();
        ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)resumed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void suspendResumeClosed() throws Exception {
        ArgumentCaptor capturedSync = ArgumentCaptor.captor((Object[])new Synchronization[0]);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ((TransactionManager)Mockito.doReturn(null, (Object[])new Object[]{tx}).when((Object)this.tm)).getTransaction();
        Batch batch = (Batch)this.factory.get();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.times((int)2))).getTransaction();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.only())).registerSynchronization((Synchronization)capturedSync.capture());
        Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)batch);
        Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
        ((TransactionManager)Mockito.doReturn((Object)tx).when((Object)this.tm)).suspend();
        SuspendedBatch suspended = batch.suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
        try (Batch resumed = suspended.resume();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
            Assertions.assertThat((Comparable)ThreadContextBatch.INSTANCE).isSameAs((Object)resumed);
            Assertions.assertThat((Object)((TransactionalBatch)TransactionalBatch.class.cast(ThreadContextBatch.INSTANCE.get())).getTransaction()).isSameAs((Object)tx);
            ((Transaction)Mockito.doReturn((Object)0, (Object[])new Object[]{0, 3}).when((Object)tx)).getStatus();
        }
        finally {
            if (!capturedSync.getAllValues().isEmpty()) {
                ((Synchronization)capturedSync.getValue()).afterCompletion(3);
            }
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.times((int)3))).getStatus();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{tx});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tm});
        Assertions.assertThat((Object)ThreadContextBatch.INSTANCE.get()).isNull();
    }
}

