/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.common.function.Functions;

public class RemoteCacheEntryComputeMutator<K, V>
implements CacheEntryMutator {
    private final RemoteCache<K, V> cache;
    private final Flag[] flags;
    private final K key;
    private final BiFunction<Object, V, V> function;
    private final Supplier<Duration> maxIdle;

    public RemoteCacheEntryComputeMutator(RemoteCache<K, V> cache, Flag[] flags, K key, BiFunction<Object, V, V> function) {
        this(cache, flags, key, function, Functions.constantSupplier((Object)Duration.ZERO));
    }

    public RemoteCacheEntryComputeMutator(RemoteCache<K, V> cache, Flag[] flags, K key, BiFunction<Object, V, V> function, Supplier<Duration> maxIdle) {
        this.cache = cache;
        this.flags = flags;
        this.key = key;
        this.function = function;
        this.maxIdle = maxIdle;
    }

    public CompletionStage<Void> mutateAsync() {
        Duration maxIdleDuration = this.maxIdle.get();
        long seconds = maxIdleDuration.getSeconds();
        int nanos = maxIdleDuration.getNano();
        if (nanos > 0) {
            ++seconds;
        }
        return this.cache.withFlags(this.flags).computeAsync(this.key, this.function, 0L, TimeUnit.SECONDS, seconds, TimeUnit.SECONDS).thenAccept(Functions.discardingConsumer());
    }
}

