/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.common.function.Functions;

public class RemoteCacheEntryMutator<K, V>
implements CacheEntryMutator {
    private final RemoteCache<K, V> cache;
    private final K id;
    private final V value;
    private final Supplier<Duration> maxIdle;

    public RemoteCacheEntryMutator(RemoteCache<K, V> cache, K id, V value) {
        this(cache, id, value, Functions.constantSupplier((Object)Duration.ZERO));
    }

    public RemoteCacheEntryMutator(RemoteCache<K, V> cache, K id, V value, Supplier<Duration> maxIdle) {
        this.cache = cache;
        this.id = id;
        this.value = value;
        this.maxIdle = maxIdle;
    }

    public CompletionStage<Void> mutateAsync() {
        Duration maxIdleDuration = this.maxIdle.get();
        long seconds = maxIdleDuration.getSeconds();
        int nanos = maxIdleDuration.getNano();
        if (nanos > 0) {
            ++seconds;
        }
        return this.cache.putAsync(this.id, this.value, 0L, TimeUnit.SECONDS, seconds, TimeUnit.SECONDS).thenAccept(Functions.discardingConsumer());
    }
}

