/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import jakarta.transaction.TransactionManager;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.infinispan.BasicCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.ReadForUpdateRemoteCache;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheContainerConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheProperties;

public interface RemoteCacheConfiguration
extends RemoteCacheContainerConfiguration,
BasicCacheConfiguration {
    public <K, V> RemoteCache<K, V> getCache();

    @Override
    default public RemoteCacheContainer getCacheContainer() {
        return this.getCache().getRemoteCacheContainer();
    }

    default public Executor getExecutor() {
        final ExecutorService executor = this.getCache().getRemoteCacheManager().getAsyncExecutorService();
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                }
                catch (IllegalLifecycleStateException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        };
    }

    default public TransactionManager getTransactionManager() {
        return this.getCache().getTransactionManager();
    }

    default public <K, V> RemoteCache<K, V> getReadForUpdateCache() {
        RemoteCache<K, V> cache = this.getCache();
        return this.getCacheProperties().isLockOnRead() ? new ReadForUpdateRemoteCache<K, V>(cache) : cache;
    }

    default public <K, V> RemoteCache<K, V> getIgnoreReturnCache() {
        RemoteCache cache = this.getCache();
        return this.getNearCacheMode().enabled() ? cache : cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
    }

    default public <K, V> RemoteCache<K, V> getForceReturnCache() {
        RemoteCache<K, V> cache = this.getCache();
        return this.getNearCacheMode().enabled() ? cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}) : cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE, Flag.SKIP_LISTENER_NOTIFICATION});
    }

    default public NearCacheMode getNearCacheMode() {
        RemoteCache cache = this.getCache();
        return ((org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration)cache.getRemoteCacheContainer().getConfiguration().remoteCaches().get(cache.getName())).nearCacheMode();
    }

    default public CacheProperties getCacheProperties() {
        return new RemoteCacheProperties(this.getCache());
    }
}

