/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.remote;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Mockito;
import org.wildfly.clustering.cache.infinispan.remote.ReadForUpdateRemoteCache;

public class ReadForUpdateRemoteCacheTestCase {
    @Test
    public void getAsync() throws SystemException {
        RemoteCache cache = (RemoteCache)Mockito.mock(RemoteCache.class);
        TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
        UUID missingKey = UUID.randomUUID();
        UUID existingKey = UUID.randomUUID();
        UUID exceptionKey = UUID.randomUUID();
        Exception exception = new Exception();
        MetadataValue staleMetadataValue = (MetadataValue)Mockito.mock(MetadataValue.class);
        String staleValue = "stale";
        long staleVersion = existingKey.getLeastSignificantBits();
        MetadataValue expectedMetadataValue = (MetadataValue)Mockito.mock(MetadataValue.class);
        String expectedValue = "expected";
        long expectedVersion = existingKey.getMostSignificantBits();
        ((RemoteCache)Mockito.doReturn((Object)tm).when((Object)cache)).getTransactionManager();
        ((TransactionManager)Mockito.doReturn((Object)0).when((Object)tm)).getStatus();
        ((RemoteCache)Mockito.doReturn((Object)cache).when((Object)cache)).withFlags((Flag[])AdditionalMatchers.aryEq((Object[])new Flag[]{Flag.FORCE_RETURN_VALUE}));
        ((MetadataValue)Mockito.doReturn((Object)staleValue).when((Object)staleMetadataValue)).getValue();
        ((MetadataValue)Mockito.doReturn((Object)staleVersion).when((Object)staleMetadataValue)).getVersion();
        ((MetadataValue)Mockito.doReturn((Object)expectedValue).when((Object)expectedMetadataValue)).getValue();
        ((MetadataValue)Mockito.doReturn((Object)expectedVersion).when((Object)expectedMetadataValue)).getVersion();
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)cache)).getWithMetadataAsync((Object)missingKey);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.failedFuture(exception)).when((Object)cache)).getWithMetadataAsync((Object)exceptionKey);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(staleMetadataValue), (Object[])new Object[]{CompletableFuture.completedFuture(expectedMetadataValue)}).when((Object)cache)).getWithMetadataAsync((Object)existingKey);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.FALSE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)staleValue, staleVersion);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.TRUE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)expectedValue, expectedVersion);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.FALSE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)staleValue, staleVersion, 0L, TimeUnit.SECONDS, 0L, TimeUnit.SECONDS);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.TRUE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)expectedValue, expectedVersion, 0L, TimeUnit.SECONDS, 0L, TimeUnit.SECONDS);
        ReadForUpdateRemoteCache subject = new ReadForUpdateRemoteCache(cache);
        Assertions.assertThat((CompletableFuture)subject.getAsync((Object)exceptionKey)).isCompletedExceptionally();
        Assertions.assertThat((CompletableFuture)subject.getAsync((Object)missingKey)).isCompletedWithValue(null);
        Assertions.assertThat((CompletableFuture)subject.getAsync((Object)existingKey)).isCompletedWithValue((Object)expectedValue);
    }

    @Test
    public void getAllAsync() throws SystemException {
        RemoteCache cache = (RemoteCache)Mockito.mock(RemoteCache.class);
        TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
        UUID missingKey = UUID.randomUUID();
        UUID existingKey = UUID.randomUUID();
        UUID exceptionKey = UUID.randomUUID();
        Exception exception = new Exception();
        MetadataValue staleMetadataValue = (MetadataValue)Mockito.mock(MetadataValue.class);
        String staleValue = "stale";
        long staleVersion = existingKey.getLeastSignificantBits();
        MetadataValue expectedMetadataValue = (MetadataValue)Mockito.mock(MetadataValue.class);
        String expectedValue = "expected";
        long expectedVersion = existingKey.getMostSignificantBits();
        ((RemoteCache)Mockito.doReturn((Object)tm).when((Object)cache)).getTransactionManager();
        ((TransactionManager)Mockito.doReturn((Object)0).when((Object)tm)).getStatus();
        ((RemoteCache)Mockito.doReturn((Object)cache).when((Object)cache)).withFlags((Flag[])AdditionalMatchers.aryEq((Object[])new Flag[]{Flag.FORCE_RETURN_VALUE}));
        ((MetadataValue)Mockito.doReturn((Object)staleValue).when((Object)staleMetadataValue)).getValue();
        ((MetadataValue)Mockito.doReturn((Object)staleVersion).when((Object)staleMetadataValue)).getVersion();
        ((MetadataValue)Mockito.doReturn((Object)expectedValue).when((Object)expectedMetadataValue)).getValue();
        ((MetadataValue)Mockito.doReturn((Object)expectedVersion).when((Object)expectedMetadataValue)).getVersion();
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)cache)).getWithMetadataAsync((Object)missingKey);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.failedFuture(exception)).when((Object)cache)).getWithMetadataAsync((Object)exceptionKey);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(staleMetadataValue), (Object[])new Object[]{CompletableFuture.completedFuture(expectedMetadataValue)}).when((Object)cache)).getWithMetadataAsync((Object)existingKey);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.FALSE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)staleValue, staleVersion);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.TRUE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)expectedValue, expectedVersion);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.FALSE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)staleValue, staleVersion, 0L, TimeUnit.SECONDS, 0L, TimeUnit.SECONDS);
        ((RemoteCache)Mockito.doReturn(CompletableFuture.completedFuture(Boolean.TRUE)).when((Object)cache)).replaceWithVersionAsync((Object)existingKey, (Object)expectedValue, expectedVersion, 0L, TimeUnit.SECONDS, 0L, TimeUnit.SECONDS);
        ReadForUpdateRemoteCache subject = new ReadForUpdateRemoteCache(cache);
        Assertions.assertThat((CompletableFuture)subject.getAllAsync(Set.of(existingKey, missingKey))).isCompletedWithValue(Map.of(existingKey, expectedValue));
        Assertions.assertThat((CompletableFuture)subject.getAllAsync(Set.of(existingKey, missingKey, exceptionKey))).isCompletedExceptionally();
    }
}

