/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public interface Locator<K, V> {
    default public V findValue(K id) {
        try {
            return this.findValueAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    public CompletionStage<V> findValueAsync(K var1);

    default public V tryValue(K id) {
        try {
            return this.tryValueAsync(id).toCompletableFuture().get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CancellationException();
        }
    }

    default public CompletionStage<V> tryValueAsync(K id) {
        return this.findValueAsync(id);
    }
}

