/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.cache.function.MapComputeFunction;
import org.wildfly.clustering.cache.function.MapPutFunction;
import org.wildfly.clustering.cache.function.MapRemoveFunction;
import org.wildfly.clustering.cache.function.SetAddFunction;
import org.wildfly.clustering.cache.function.SetRemoveFunction;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamTesterFactory;

public class FunctionTestCase {
    @Test
    public void set() {
        Set result = (Set)new SetAddFunction((Object)"foo").apply(null, null);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.contains("foo"));
        Set result2 = (Set)new SetAddFunction((Object)"bar").apply(null, (Object)result);
        Assertions.assertNotNull((Object)result2);
        Assertions.assertNotSame((Object)result, (Object)result2);
        Assertions.assertTrue((boolean)result2.contains("foo"));
        Assertions.assertTrue((boolean)result2.contains("bar"));
        Set result3 = (Set)new SetAddFunction(Set.of("baz", "qux")).apply(null, (Object)result2);
        Assertions.assertNotNull((Object)result3);
        Assertions.assertNotSame((Object)result2, (Object)result3);
        Assertions.assertTrue((boolean)result3.contains("foo"));
        Assertions.assertTrue((boolean)result3.contains("bar"));
        Assertions.assertTrue((boolean)result3.contains("baz"));
        Assertions.assertTrue((boolean)result3.contains("qux"));
        Set result4 = (Set)new SetRemoveFunction((Object)"foo").apply(null, (Object)result3);
        Assertions.assertNotNull((Object)result4);
        Assertions.assertNotSame((Object)result3, (Object)result4);
        Assertions.assertFalse((boolean)result4.contains("foo"));
        Assertions.assertTrue((boolean)result4.contains("bar"));
        Assertions.assertTrue((boolean)result4.contains("baz"));
        Assertions.assertTrue((boolean)result4.contains("qux"));
        Set result5 = (Set)new SetRemoveFunction(Set.of("bar", "baz")).apply(null, (Object)result4);
        Assertions.assertNotNull((Object)result5);
        Assertions.assertNotSame((Object)result4, (Object)result5);
        Assertions.assertFalse((boolean)result5.contains("foo"));
        Assertions.assertFalse((boolean)result5.contains("bar"));
        Assertions.assertFalse((boolean)result5.contains("baz"));
        Assertions.assertTrue((boolean)result5.contains("qux"));
        Set result6 = (Set)new SetRemoveFunction((Object)"qux").apply(null, (Object)result5);
        Assertions.assertNull((Object)result6);
    }

    @Test
    public void map() {
        Map result = (Map)new MapPutFunction((Object)"foo", (Object)"a").apply(null, null);
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.containsKey("foo"));
        Map result2 = (Map)new MapPutFunction((Object)"bar", (Object)"b").apply(null, (Object)result);
        Assertions.assertNotNull((Object)result2);
        Assertions.assertNotSame((Object)result, (Object)result2);
        Assertions.assertTrue((boolean)result2.containsKey("foo"));
        Assertions.assertTrue((boolean)result2.containsKey("bar"));
        Map result3 = (Map)new MapRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assertions.assertNotNull((Object)result3);
        Assertions.assertNotSame((Object)result2, (Object)result3);
        Assertions.assertFalse((boolean)result3.containsKey("foo"));
        Assertions.assertTrue((boolean)result3.containsKey("bar"));
        Map result4 = (Map)new MapRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assertions.assertNull((Object)result4);
        Map result5 = (Map)new MapComputeFunction(Map.of("foo", "a", "bar", "b")).apply(null, (Object)result4);
        Assertions.assertNotNull((Object)result5);
        Assertions.assertEquals((int)2, (int)result5.size());
        Assertions.assertEquals((Object)"a", result5.get("foo"));
        Assertions.assertEquals((Object)"b", result5.get("bar"));
        TreeMap<String, String> updates = new TreeMap<String, String>();
        updates.put("foo", null);
        updates.put("bar", "c");
        Map result6 = (Map)new MapComputeFunction(updates).apply(null, (Object)result5);
        Assertions.assertNotNull((Object)result6);
        Assertions.assertEquals((int)1, (int)result6.size());
        Assertions.assertFalse((boolean)result6.containsKey("foo"));
        Assertions.assertEquals((Object)"c", result6.get("bar"));
        Map result7 = (Map)new MapComputeFunction(Collections.singletonMap("bar", null)).apply(null, (Object)result6);
        Assertions.assertNull((Object)result7);
    }

    @Test
    public void marshalling() throws IOException {
        ProtoStreamTesterFactory factory = ProtoStreamTesterFactory.INSTANCE;
        factory.createTester().test((Object)new SetAddFunction(List.of("foo", "bar")));
        factory.createTester().test((Object)new SetRemoveFunction(List.of("foo", "bar")));
        factory.createTester().test((Object)new MapPutFunction((Object)"foo", (Object)"bar"));
        factory.createTester().test((Object)new MapRemoveFunction((Object)"foo"));
        TreeMap<String, String> values = new TreeMap<String, String>();
        values.put("foo", "bar");
        values.put("baz", null);
        factory.createTester().test((Object)new MapComputeFunction(values));
    }
}

