/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.Container;
import org.testcontainers.lifecycle.Startable;
import org.wildfly.clustering.cache.ContainerProvider;

public class ContainerExtension<C extends Container<C> & Startable>
implements AfterAllCallback,
BeforeAllCallback,
ContainerProvider<C> {
    protected static final Logger LOGGER = Logger.getLogger(ContainerExtension.class);
    private final Function<ExtensionContext, C> factory;
    private C container;

    public ContainerExtension(Function<ExtensionContext, C> factory) {
        this.factory = factory;
    }

    @Override
    public C getContainer() {
        return this.container;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.container = (Container)this.factory.apply(context);
        LOGGER.infof("Starting %s", (Object)this.container.getDockerImageName());
        Instant start = Instant.now();
        ((Startable)this.container).start();
        LOGGER.infof("Started %s in %s", (Object)this.container.getDockerImageName(), (Object)Duration.between(start, Instant.now()));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.container != null) {
            LOGGER.infof("Starting %s", (Object)this.container.getDockerImageName());
            Instant start = Instant.now();
            ((Startable)this.container).stop();
            LOGGER.infof("Stopped %s in %s", (Object)this.container.getDockerImageName(), (Object)Duration.between(start, Instant.now()));
        }
    }
}

