/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.batch;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;

public class BatchContextTestCase {
    @Test
    public void suspendWithContext() {
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspended = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        ((Batch)Mockito.doReturn((Object)suspended).when((Object)batch)).suspend();
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)suspended)).resume();
        ((Batch)Mockito.doCallRealMethod().when((Object)batch)).suspendWithContext();
        try (Context context = batch.suspendWithContext();){
            ((Batch)Mockito.verify((Object)batch)).suspendWithContext();
            ((Batch)Mockito.verify((Object)batch)).suspend();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch});
            Mockito.verifyNoInteractions((Object[])new Object[]{suspended});
            Assertions.assertThat((Object)((SuspendedBatch)context.get())).isSameAs((Object)suspended);
        }
        ((SuspendedBatch)Mockito.verify((Object)suspended, (VerificationMode)Mockito.only())).resume();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{batch});
    }

    @Test
    public void resumeWithContext() {
        Batch batch = (Batch)Mockito.mock(Batch.class);
        SuspendedBatch suspended = (SuspendedBatch)Mockito.mock(SuspendedBatch.class);
        ((Batch)Mockito.doReturn((Object)suspended).when((Object)batch)).suspend();
        ((SuspendedBatch)Mockito.doReturn((Object)batch).when((Object)suspended)).resume();
        ((SuspendedBatch)Mockito.doCallRealMethod().when((Object)suspended)).resumeWithContext();
        try (Context context = suspended.resumeWithContext();){
            ((SuspendedBatch)Mockito.verify((Object)suspended)).resumeWithContext();
            ((SuspendedBatch)Mockito.verify((Object)suspended)).resume();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{suspended});
            Mockito.verifyNoInteractions((Object[])new Object[]{batch});
            Assertions.assertThat((Object)((Batch)context.get())).isSameAs((Object)batch);
        }
        ((Batch)Mockito.verify((Object)batch, (VerificationMode)Mockito.only())).suspend();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{suspended});
    }
}

