/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public interface Function<T, R>
extends java.util.function.Function<T, R> {
    public static final Function<?, ?> IDENTITY = new Function<Object, Object>(){

        @Override
        public Object apply(Object value) {
            return value;
        }
    };
    public static final Function<?, ?> NULL = new Function<Object, Object>(){

        @Override
        public Object apply(Object value) {
            return null;
        }
    };

    @Override
    default public <V> Function<V, R> compose(final java.util.function.Function<? super V, ? extends T> before) {
        return new Function<V, R>(){

            @Override
            public R apply(V value) {
                return Function.this.apply(before.apply(value));
            }
        };
    }

    @Override
    default public <V> Function<T, V> andThen(final java.util.function.Function<? super R, ? extends V> after) {
        return new Function<T, V>(){

            @Override
            public V apply(T value) {
                return after.apply(Function.this.apply(value));
            }
        };
    }

    default public Function<T, R> withDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultValue) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                return Function.this.apply(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public Function<T, R> orDefault(final Predicate<T> predicate, final java.util.function.Supplier<R> defaultResult) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                return predicate.test(value) ? Function.this.apply(value) : defaultResult.get();
            }
        };
    }

    public static <T extends R, R> Function<T, R> identity() {
        return IDENTITY;
    }

    public static <T, R> Function<T, R> of(final R result) {
        return result != null ? new Function<T, R>(){

            @Override
            public R apply(T ignore) {
                return result;
            }
        } : NULL;
    }

    public static <T, R> Function<T, R> of(final java.util.function.Supplier<R> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new Function<T, R>(){

            @Override
            public R apply(T ignore) {
                return supplier.get();
            }
        } : NULL;
    }
}

