/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.function.Function;

public interface Consumer<T>
extends java.util.function.Consumer<T> {
    public static final Consumer<?> EMPTY = new Consumer<Object>(){

        @Override
        public void accept(Object value) {
        }
    };
    public static final Consumer<AutoCloseable> CLOSE = new Consumer<AutoCloseable>(){
        private final System.Logger logger = System.getLogger(Consumer.class.getName());

        @Override
        public void accept(AutoCloseable object) {
            if (object != null) {
                try {
                    object.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    };

    @Override
    default public Consumer<T> andThen(java.util.function.Consumer<? super T> after) {
        return Consumer.of(List.of(this, after));
    }

    default public <V> Consumer<V> map(final Function<V, T> mapper) {
        return new Consumer<V>(){

            @Override
            public void accept(V value) {
                Consumer.this.accept(mapper.apply(value));
            }
        };
    }

    public static <V> Consumer<V> empty() {
        return EMPTY;
    }

    public static <V extends AutoCloseable> Consumer<V> close() {
        return CLOSE;
    }

    public static <V> Consumer<V> of(final Runnable task) {
        return new Consumer<V>(){

            @Override
            public void accept(V ignored) {
                task.run();
            }
        };
    }

    public static <V> Consumer<V> of(final Iterable<java.util.function.Consumer<? super V>> consumers) {
        return new Consumer<V>(){

            @Override
            public void accept(V value) {
                for (java.util.function.Consumer consumer : consumers) {
                    consumer.accept(value);
                }
            }
        };
    }
}

