/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.wildfly.clustering.function.BiPredicate;

public class BiPredicateTestCase {
    private Object value1 = new Object();
    private Object value2 = new Object();

    @Test
    public void former() {
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate1)).test(this.value1);
        BiPredicate predicate = BiPredicate.former((Predicate)predicate1);
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isFalse();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isTrue();
    }

    @Test
    public void latter() {
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate2)).test(this.value2);
        BiPredicate predicate = BiPredicate.latter((Predicate)predicate2);
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isFalse();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isTrue();
    }

    @Test
    public void negate() {
        BiPredicate predicate = (BiPredicate)Mockito.mock(BiPredicate.class);
        ((BiPredicate)Mockito.doCallRealMethod().when((Object)predicate)).negate();
        ((BiPredicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(this.value1, this.value2);
        BiPredicate negative = predicate.negate();
        Assertions.assertThat((boolean)negative.test(this.value1, this.value2)).isTrue();
        Assertions.assertThat((boolean)negative.test(this.value1, this.value2)).isFalse();
    }

    @Test
    public void and() {
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate1)).test(this.value1);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate2)).test(this.value2);
        BiPredicate predicate = BiPredicate.and((Predicate)predicate1, (Predicate)predicate2);
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isFalse();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isFalse();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isFalse();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isTrue();
    }

    @Test
    public void or() {
        Predicate predicate1 = (Predicate)Mockito.mock(Predicate.class);
        Predicate predicate2 = (Predicate)Mockito.mock(Predicate.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{false, true, true}).when((Object)predicate1)).test(this.value1);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true, false, true}).when((Object)predicate2)).test(this.value2);
        BiPredicate predicate = BiPredicate.or((Predicate)predicate1, (Predicate)predicate2);
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isFalse();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isTrue();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isTrue();
        Assertions.assertThat((boolean)predicate.test(this.value1, this.value2)).isTrue();
    }
}

