/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.wildfly.clustering.function.BiConsumer;
import org.wildfly.clustering.function.Function;

public class BiConsumerTestCase {
    private Object value1 = new Object();
    private Object value2 = new Object();

    @Test
    public void empty() {
        BiConsumer consumer = BiConsumer.empty();
        consumer.accept(this.value1, this.value2);
        consumer.accept(this.value1, null);
        consumer.accept(null, this.value2);
        consumer.accept(null, null);
    }

    @Test
    public void compose() {
        BiConsumer consumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        ((BiConsumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((Function)ArgumentMatchers.any(), (Function)ArgumentMatchers.any());
        Function mapper1 = (Function)Mockito.mock(Function.class);
        Function mapper2 = (Function)Mockito.mock(Function.class);
        Object value1 = new Object();
        Object value2 = new Object();
        Object mapped1 = new Object();
        Object mapped2 = new Object();
        ((Function)Mockito.doReturn((Object)mapped1).when((Object)mapper1)).apply(value1);
        ((Function)Mockito.doReturn((Object)mapped2).when((Object)mapper2)).apply(value2);
        consumer.compose(mapper1, mapper2).accept(value1, value2);
        ((BiConsumer)Mockito.verify((Object)consumer)).accept(mapped1, mapped2);
    }

    @Test
    public void andThen() {
        BiConsumer before = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer after = (BiConsumer)Mockito.mock(BiConsumer.class);
        ((BiConsumer)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.BiConsumer)ArgumentMatchers.any());
        InOrder order = Mockito.inOrder((Object[])new Object[]{before, after});
        before.andThen((java.util.function.BiConsumer)after).accept(this.value1, this.value2);
        ((BiConsumer)order.verify((Object)before)).accept(this.value1, this.value2);
        ((BiConsumer)order.verify((Object)after)).accept(this.value1, this.value2);
    }

    @Test
    public void reverse() {
        BiConsumer consumer = (BiConsumer)Mockito.mock(BiConsumer.class);
        ((BiConsumer)Mockito.doCallRealMethod().when((Object)consumer)).reverse();
        consumer.reverse().accept(this.value1, this.value2);
        ((BiConsumer)Mockito.verify((Object)consumer)).accept(this.value2, this.value1);
    }

    @Test
    public void composite() {
        BiConsumer consumer1 = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer consumer2 = (BiConsumer)Mockito.mock(BiConsumer.class);
        BiConsumer consumer3 = (BiConsumer)Mockito.mock(BiConsumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2, consumer3});
        BiConsumer.of(List.of(consumer1, consumer2, consumer3)).accept(this.value1, this.value2);
        ((BiConsumer)order.verify((Object)consumer1)).accept(this.value1, this.value2);
        ((BiConsumer)order.verify((Object)consumer2)).accept(this.value1, this.value2);
        ((BiConsumer)order.verify((Object)consumer3)).accept(this.value1, this.value2);
    }

    @Test
    public void former() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        BiConsumer.former((Consumer)consumer).accept(this.value1, this.value2);
        ((Consumer)Mockito.verify((Object)consumer)).accept(this.value1);
    }

    @Test
    public void latter() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        BiConsumer.latter((Consumer)consumer).accept(this.value1, this.value2);
        ((Consumer)Mockito.verify((Object)consumer)).accept(this.value2);
    }

    @Test
    public void of() {
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2});
        BiConsumer.of((Consumer)consumer1, (Consumer)consumer2).accept(this.value1, this.value2);
        ((Consumer)order.verify((Object)consumer1)).accept(this.value1);
        ((Consumer)order.verify((Object)consumer2)).accept(this.value2);
    }
}

