/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Runnable;

public class ConsumerTestCase {
    @Test
    public void compose() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)consumer)).compose((java.util.function.Function)ArgumentMatchers.any());
        Function mapper = (Function)Mockito.mock(Function.class);
        Object value = new Object();
        Object result = new Object();
        ((Function)Mockito.doReturn((Object)result).when((Object)mapper)).apply(value);
        consumer.compose((java.util.function.Function)mapper).accept(value);
        ((Consumer)Mockito.verify((Object)consumer)).accept(result);
    }

    @Test
    public void empty() {
        Consumer consumer = Consumer.empty();
        consumer.accept(new Object());
        consumer.accept(null);
    }

    @Test
    public void close() throws Exception {
        AutoCloseable resource = (AutoCloseable)Mockito.mock(AutoCloseable.class);
        Consumer consumer = Consumer.close((Consumer)Consumer.debug());
        consumer.accept((Object)resource);
        ((AutoCloseable)Mockito.verify((Object)resource)).close();
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{new Exception()}).when((Object)resource)).close();
        consumer.accept((Object)resource);
        IllegalStateException exception = new IllegalStateException();
        ((AutoCloseable)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)resource)).close();
        Assertions.assertThatThrownBy(resource::close).isSameAs((Object)exception);
    }

    @Test
    public void ofRunnable() {
        Object value = new Object();
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Consumer consumer = Consumer.of((java.lang.Runnable)runnable);
        consumer.accept(value);
        ((Runnable)Mockito.verify((Object)runnable)).run();
    }

    @Test
    public void andThen() {
        Object value = new Object();
        Consumer before = (Consumer)Mockito.mock(Consumer.class);
        ((Consumer)Mockito.doCallRealMethod().when((Object)before)).andThen((java.util.function.Consumer)ArgumentMatchers.any());
        Consumer after = (Consumer)Mockito.mock(Consumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{before, after});
        before.andThen((java.util.function.Consumer)after).accept(value);
        ((Consumer)order.verify((Object)before)).accept(value);
        ((Consumer)order.verify((Object)after)).accept(value);
    }

    @Test
    public void composite() {
        Object value = new Object();
        Consumer consumer1 = (Consumer)Mockito.mock(Consumer.class);
        Consumer consumer2 = (Consumer)Mockito.mock(Consumer.class);
        Consumer consumer3 = (Consumer)Mockito.mock(Consumer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{consumer1, consumer2, consumer3});
        Consumer consumer = Consumer.of(List.of(consumer1, consumer2, consumer3));
        consumer.accept(value);
        ((Consumer)order.verify((Object)consumer1)).accept(value);
        ((Consumer)order.verify((Object)consumer2)).accept(value);
        ((Consumer)order.verify((Object)consumer3)).accept(value);
    }
}

