/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public class FunctionTestCase {
    @Test
    public void ofValue() {
        Object expected = new Object();
        Assertions.assertThat((Object)Function.of((Object)expected).apply(new Object())).isSameAs(expected);
        Assertions.assertThat((Object)Function.of(null).apply(new Object())).isNull();
    }

    @Test
    public void ofRunnable() {
        Object expected = new Object();
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Supplier)Mockito.doReturn((Object)expected).when((Object)supplier)).get();
        Assertions.assertThat((Object)Function.of((java.util.function.Supplier)supplier).apply(new Object())).isSameAs(expected);
        supplier = null;
        Assertions.assertThat((Object)Function.of((java.util.function.Supplier)supplier).apply(new Object())).isNull();
    }

    @Test
    public void withDefault() {
        Object result = new Object();
        Object value = new Object();
        Object defaultValue = new Object();
        Object defaultResult = new Object();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).withDefault((java.util.function.Predicate)ArgumentMatchers.any(), (java.util.function.Supplier)ArgumentMatchers.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(value);
        ((Supplier)Mockito.doReturn((Object)defaultValue).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply(value);
        ((Function)Mockito.doReturn((Object)defaultResult).when((Object)function)).apply(defaultValue);
        Assertions.assertThat((Object)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(defaultResult);
        Assertions.assertThat((Object)function.withDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(result);
    }

    @Test
    public void orDefault() {
        Object result = new Object();
        Object value = new Object();
        Object defaultResult = new Object();
        Function function = (Function)Mockito.mock(Function.class);
        ((Function)Mockito.doCallRealMethod().when((Object)function)).orDefault((java.util.function.Predicate)ArgumentMatchers.any(), (java.util.function.Supplier)ArgumentMatchers.any());
        Predicate predicate = (Predicate)Mockito.mock(Predicate.class);
        Supplier supplier = (Supplier)Mockito.mock(Supplier.class);
        ((Predicate)Mockito.doReturn((Object)false, (Object[])new Object[]{true}).when((Object)predicate)).test(value);
        ((Supplier)Mockito.doReturn((Object)defaultResult).when((Object)supplier)).get();
        ((Function)Mockito.doReturn((Object)result).when((Object)function)).apply(value);
        Assertions.assertThat((Object)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(defaultResult);
        Assertions.assertThat((Object)function.orDefault((java.util.function.Predicate)predicate, (java.util.function.Supplier)supplier).apply(value)).isSameAs(result);
    }
}

