/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.List;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.function.Function;

public interface BiConsumer<T, U>
extends java.util.function.BiConsumer<T, U> {
    public static final BiConsumer<?, ?> EMPTY = new BiConsumer<Object, Object>(){

        @Override
        public void accept(Object ignore1, Object ignore2) {
        }
    };

    @Override
    default public BiConsumer<T, U> andThen(java.util.function.BiConsumer<? super T, ? super U> after) {
        return BiConsumer.acceptAll(List.of(this, after));
    }

    default public <V1, V2> BiConsumer<V1, V2> compose(final Function<V1, T> mapper1, final Function<V2, U> mapper2) {
        return new BiConsumer<V1, V2>(){

            @Override
            public void accept(V1 value1, V2 value2) {
                BiConsumer.this.accept(mapper1.apply(value1), mapper2.apply(value2));
            }
        };
    }

    default public BiConsumer<U, T> reverse() {
        return new BiConsumer<U, T>(){

            @Override
            public void accept(U value1, T value2) {
                BiConsumer.this.accept(value2, value1);
            }
        };
    }

    default public BiConsumer<T, U> handle(final java.util.function.Consumer<RuntimeException> handler) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                try {
                    BiConsumer.this.accept(value1, value2);
                }
                catch (RuntimeException e) {
                    handler.accept(e);
                }
            }
        };
    }

    public static <T, U> BiConsumer<T, U> empty() {
        return EMPTY;
    }

    public static <T, U> BiConsumer<T, U> former(java.util.function.Consumer<? super T> consumer) {
        return BiConsumer.of(consumer, Consumer.empty());
    }

    public static <T, U> BiConsumer<T, U> latter(java.util.function.Consumer<? super U> consumer) {
        return BiConsumer.of(Consumer.empty(), consumer);
    }

    public static <T, U> BiConsumer<T, U> of(final java.util.function.Consumer<? super T> consumer1, final java.util.function.Consumer<? super U> consumer2) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                consumer1.accept(value1);
                consumer2.accept(value2);
            }
        };
    }

    public static <T, U> BiConsumer<T, U> acceptAll(final Iterable<? extends java.util.function.BiConsumer<? super T, ? super U>> consumers) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                for (java.util.function.BiConsumer consumer : consumers) {
                    consumer.accept(value1, value2);
                }
            }
        };
    }
}

