/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Runnable;
import org.wildfly.clustering.function.Supplier;

public interface Callable<T>
extends java.util.concurrent.Callable<T> {
    public static final Callable<?> NULL = new Callable<Object>(){

        @Override
        public Object call() {
            return null;
        }
    };

    default public <R> Callable<R> map(final Function<T, R> mapper) {
        return new Callable<R>(){

            @Override
            public R call() throws Exception {
                return mapper.apply(Callable.this.call());
            }
        };
    }

    public static <T> Callable<T> empty() {
        return NULL;
    }

    public static <T> Callable<T> run(final Runnable runner) {
        return runner != null && runner != Runnable.EMPTY ? new Callable<T>(){

            @Override
            public T call() {
                runner.run();
                return null;
            }
        } : Callable.empty();
    }

    public static <T> Callable<T> get(final Supplier<T> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new Callable<T>(){

            @Override
            public T call() {
                return supplier.get();
            }
        } : Callable.empty();
    }

    public static <T> Callable<T> of(final T value) {
        return value != null ? new Callable<T>(){

            @Override
            public T call() {
                return value;
            }
        } : Callable.empty();
    }

    public static <T> Callable<T> exceptional(final Supplier<? extends Exception> exceptionProvider) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                throw (Exception)exceptionProvider.get();
            }
        };
    }
}

