/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.java;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.wildfly.clustering.marshalling.Serializer;

public class ObjectInputStream
extends java.io.ObjectInputStream {
    private static final InvocationHandler NULL_HANDLER = (proxy, method, args) -> null;
    private final Serializer<ClassLoader> serializer;

    public ObjectInputStream(InputStream input, Serializer<ClassLoader> serializer) throws IOException {
        super(input);
        this.serializer = serializer;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass description) throws IOException, ClassNotFoundException {
        String className = description.getName();
        return Class.forName(className, false, (ClassLoader)this.serializer.read((DataInput)this));
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfaceClasses = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceClasses[i] = Class.forName(interfaces[i], false, (ClassLoader)this.serializer.read((DataInput)this));
        }
        try {
            return Proxy.newProxyInstance((ClassLoader)this.serializer.read((DataInput)this), interfaceClasses, NULL_HANDLER).getClass();
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

