/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.IndexSerializer;
import org.wildfly.clustering.marshalling.IntSerializer;
import org.wildfly.common.function.ExceptionBiConsumer;

public interface IdentityTable<T> {
    public ExceptionBiConsumer<Marshaller, T, IOException> findWriter(T var1);

    public T read(Unmarshaller var1) throws IOException;

    public static <T> IdentityTable<T> from(final List<T> objects) {
        final IntSerializer indexSerializer = IndexSerializer.select((int)objects.size());
        final IdentityHashMap indexes = new IdentityHashMap(objects.size());
        ListIterator<T> iterator = objects.listIterator();
        while (iterator.hasNext()) {
            indexes.putIfAbsent(iterator.next(), iterator.previousIndex());
        }
        final ExceptionBiConsumer writer = (marshaller, object) -> indexSerializer.writeInt((DataOutput)marshaller, ((Integer)indexes.get(object)).intValue());
        return new IdentityTable<T>(){

            @Override
            public ExceptionBiConsumer<Marshaller, T, IOException> findWriter(T object) {
                Integer index = (Integer)indexes.get(object);
                return index != null ? writer : null;
            }

            @Override
            public T read(Unmarshaller unmarshaller) throws IOException {
                return objects.get(indexSerializer.readInt((DataInput)unmarshaller));
            }
        };
    }
}

