/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.EnumSet;
import java.util.function.Function;
import org.jboss.marshalling.MarshallingConfiguration;

public interface MarshallingConfigurationRepository {
    public int getCurrentVersion();

    public MarshallingConfiguration getMarshallingConfiguration(int var1);

    public static <C, E extends Enum<E>> MarshallingConfigurationRepository from(E current, C context) {
        return MarshallingConfigurationRepository.from(current.ordinal() + 1, (MarshallingConfiguration[])EnumSet.allOf(current.getDeclaringClass()).stream().map(c -> (MarshallingConfiguration)((Function)((Object)c)).apply(context)).toArray(MarshallingConfiguration[]::new));
    }

    public static MarshallingConfigurationRepository from(MarshallingConfiguration ... configurations) {
        return MarshallingConfigurationRepository.from(configurations.length, configurations);
    }

    public static MarshallingConfigurationRepository from(final int currentVersion, final MarshallingConfiguration ... configurations) {
        return new MarshallingConfigurationRepository(){

            @Override
            public int getCurrentVersion() {
                return currentVersion;
            }

            @Override
            public MarshallingConfiguration getMarshallingConfiguration(int version) {
                return configurations[version - 1];
            }
        };
    }
}

