/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jboss.marshalling.ChainingObjectTable;
import org.jboss.marshalling.ObjectTable;
import org.wildfly.clustering.marshalling.jboss.DefaultObjectTableProvider;

public class LoadedObjectTable
extends ChainingObjectTable {
    public LoadedObjectTable(ClassLoader loader) {
        this(List.of(loader));
    }

    public LoadedObjectTable(List<ClassLoader> loaders) {
        super(LoadedObjectTable.load(loaders));
    }

    private static ObjectTable[] load(List<ClassLoader> loaders) {
        ArrayList loadedTables = new ArrayList(loaders.size());
        for (ClassLoader loader : loaders) {
            ServiceLoader.load(ObjectTable.class, loader).findFirst().ifPresent(loadedTables::add);
        }
        Stream<ObjectTable> tables = EnumSet.allOf(DefaultObjectTableProvider.class).stream().map(Supplier::get);
        if (!loadedTables.isEmpty()) {
            tables = Stream.concat(tables, loadedTables.stream());
        }
        return (ObjectTable[])tables.toArray(ObjectTable[]::new);
    }
}

