/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum StackTraceElementMarshaller implements ProtoStreamMarshaller<StackTraceElement>
{
    INSTANCE;

    private static final int CLASS_NAME_INDEX = 1;
    private static final int METHOD_NAME_INDEX = 2;
    private static final int FILE_NAME_INDEX = 3;
    private static final int LINE_NUMBER_INDEX = 4;
    private static final int CLASS_LOADER_NAME_INDEX = 5;
    private static final int MODULE_NAME_INDEX = 6;
    private static final int MODULE_VERSION_INDEX = 7;

    @Override
    public StackTraceElement readFrom(ProtoStreamReader reader) throws IOException {
        String className = null;
        String methodName = null;
        String fileName = null;
        int line = -1;
        String classLoaderName = null;
        String moduleName = null;
        String moduleVersion = null;
        block9: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    className = reader.readString();
                    continue block9;
                }
                case 2: {
                    methodName = reader.readString();
                    continue block9;
                }
                case 3: {
                    fileName = reader.readString();
                    continue block9;
                }
                case 4: {
                    line = reader.readUInt32();
                    if (line != 0) continue block9;
                    line = -2;
                    continue block9;
                }
                case 5: {
                    classLoaderName = reader.readString();
                    continue block9;
                }
                case 6: {
                    moduleName = reader.readString();
                    continue block9;
                }
                case 7: {
                    moduleVersion = reader.readString();
                    continue block9;
                }
            }
            reader.skipField(tag);
        }
        return new StackTraceElement(classLoaderName, moduleName, moduleVersion, className, methodName, fileName, line);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, StackTraceElement element) throws IOException {
        String moduleVersion;
        String moduleName;
        String classLoaderName;
        writer.writeString(1, element.getClassName());
        writer.writeString(2, element.getMethodName());
        String fileName = element.getFileName();
        if (fileName != null) {
            writer.writeString(3, fileName);
        }
        int line = element.getLineNumber();
        boolean nativeMethod = element.isNativeMethod();
        if (nativeMethod || line > 0) {
            writer.writeUInt32(4, nativeMethod ? 0 : line);
        }
        if ((classLoaderName = element.getClassLoaderName()) != null) {
            writer.writeString(5, classLoaderName);
        }
        if ((moduleName = element.getModuleName()) != null) {
            writer.writeString(6, moduleName);
        }
        if ((moduleVersion = element.getModuleVersion()) != null) {
            writer.writeString(7, moduleVersion);
        }
    }

    @Override
    public Class<? extends StackTraceElement> getJavaClass() {
        return StackTraceElement.class;
    }
}

