/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import org.infinispan.protostream.DescriptorParserException;
import org.wildfly.clustering.marshalling.protostream.Reflect;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;

public abstract class AbstractSerializationContextInitializer
implements SerializationContextInitializer {
    private final String resourceName;
    private final ClassLoader loader;

    protected AbstractSerializationContextInitializer() {
        this.resourceName = this.getClass().getPackage().getName() + ".proto";
        this.loader = Reflect.getClassLoader(this.getClass());
    }

    protected AbstractSerializationContextInitializer(String resourceName) {
        this.resourceName = resourceName;
        this.loader = Reflect.getClassLoader(this.getClass());
    }

    protected AbstractSerializationContextInitializer(String resourceName, Class<?> containingClass) {
        this.resourceName = resourceName;
        this.loader = Reflect.getClassLoader(containingClass);
    }

    @Override
    public void registerSchema(SerializationContext context) {
        try {
            context.registerProtoFiles(Reflect.loadSchemas(this.resourceName, this.loader));
        }
        catch (DescriptorParserException e) {
            try {
                context.unregisterProtoFile(this.resourceName);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String toString() {
        return this.resourceName;
    }
}

