/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.reflect;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.reflect.Reflect;

public class FieldMarshaller<T>
implements ProtoStreamMarshaller<T> {
    private final Class<? extends T> type;
    private final Supplier<? extends T> factory;
    private final Field[] fields;

    public FieldMarshaller(Class<? extends T> type, Class<?> ... memberTypes) {
        this(type, FieldMarshaller.defaultFactory(type), memberTypes);
    }

    private static <T> Supplier<T> defaultFactory(Class<T> type) {
        Constructor constructor = Reflect.getConstructor(type, new Class[0]);
        return () -> Reflect.newInstance(constructor, new Object[0]);
    }

    public FieldMarshaller(Class<? extends T> type, Supplier<? extends T> factory, Class<?> ... memberTypes) {
        this.type = type;
        this.factory = factory;
        this.fields = new Field[memberTypes.length];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = Reflect.findField(type, memberTypes[i]);
        }
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.type;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        T result = this.factory.get();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index > 0 || index <= this.fields.length) {
                Reflect.setValue(result, this.fields[index - 1], reader.readAny());
                continue;
            }
            reader.skipField(tag);
        }
        return result;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T source) throws IOException {
        for (int i = 0; i < this.fields.length; ++i) {
            Object value = Reflect.getValue(source, this.fields[i]);
            if (value == null) continue;
            writer.writeAny(i + 1, value);
        }
    }
}

