/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;

public class LinkedHashMapMarshaller
extends AbstractMapMarshaller<LinkedHashMap<Object, Object>> {
    private static final int ACCESS_ORDER_INDEX = 3;
    private static final Function<LinkedHashMap<Object, Object>, Boolean> ACCESS_ORDER = new Function<LinkedHashMap<Object, Object>, Boolean>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean apply(LinkedHashMap<Object, Object> map) {
            Object insertOrder = new Object();
            map.put(insertOrder, null);
            try {
                Boolean bl;
                Object accessOrder = new Object();
                map.put(accessOrder, null);
                try {
                    map.get(insertOrder);
                    Iterator<Object> keys = map.keySet().iterator();
                    Object element = keys.next();
                    while (element != insertOrder && element != accessOrder) {
                        element = keys.next();
                    }
                    bl = element == accessOrder;
                }
                catch (Throwable throwable) {
                    map.remove(accessOrder);
                    throw throwable;
                }
                map.remove(accessOrder);
                return bl;
            }
            finally {
                map.remove(insertOrder);
            }
        }
    };

    public LinkedHashMapMarshaller() {
        super(LinkedHashMap.class);
    }

    @Override
    public LinkedHashMap<Object, Object> readFrom(ProtoStreamReader reader) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(16, 0.75f, false);
        LinkedList<Object> keys = new LinkedList<Object>();
        LinkedList<Object> values = new LinkedList<Object>();
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    keys.add(reader.readAny());
                    continue block5;
                }
                case 2: {
                    values.add(reader.readAny());
                    continue block5;
                }
                case 3: {
                    map = new LinkedHashMap(16, 0.75f, reader.readBool());
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        Iterator keyIterator = keys.iterator();
        Iterator valueIterator = values.iterator();
        while (keyIterator.hasNext() || valueIterator.hasNext()) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ProtoStreamWriter writer, LinkedHashMap<Object, Object> map) throws IOException {
        LinkedHashMap<Object, Object> linkedHashMap = map;
        synchronized (linkedHashMap) {
            super.writeTo(writer, map);
            boolean accessOrder = ACCESS_ORDER.apply(map);
            if (accessOrder) {
                writer.writeBool(3, accessOrder);
            }
        }
    }
}

