/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.net;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.net.Inet;

public enum InetAddressMarshaller implements FieldSetMarshaller.Simple<InetAddress>
{
    INSTANCE;

    private static final InetAddress DEFAULT;
    private static final int HOST_NAME_INDEX = 0;
    private static final int ADDRESS_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public InetAddress createInitialValue() {
        return DEFAULT;
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public InetAddress readFrom(ProtoStreamReader reader, int index, WireType type, InetAddress address) throws IOException {
        switch (index) {
            case 0: {
                String hostName = reader.readString();
                return InetAddress.getByName(hostName);
            }
            case 1: {
                return InetAddress.getByAddress(reader.readByteArray());
            }
        }
        reader.skipField(type);
        return address;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, InetAddress address) throws IOException {
        String hostName = Inet.getHostNameIfResolved((InetAddress)address);
        if (hostName != null) {
            if (!hostName.equals(DEFAULT.getHostName())) {
                writer.writeString(0, hostName);
            }
        } else {
            byte[] bytes = address.getAddress();
            if (!Arrays.equals(bytes, DEFAULT.getAddress())) {
                writer.writeBytes(1, address.getAddress());
            }
        }
    }

    static {
        DEFAULT = InetAddress.getLoopbackAddress();
    }
}

