/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.StringKeyMapEntry;

public class StringKeyMapMarshaller<V, T extends Map<String, V>>
implements ProtoStreamMarshaller<T> {
    private static final int ENTRY_INDEX = 1;
    private final Supplier<T> factory;
    private final Function<T, Set<String>> keys;
    private final BiFunction<T, String, V> value;
    private final BiConsumer<T, Map.Entry<String, V>> accumulator;

    public StringKeyMapMarshaller(Supplier<T> factory, Function<T, Set<String>> keys, BiFunction<T, String, V> value, BiConsumer<T, Map.Entry<String, V>> accumulator) {
        this.factory = factory;
        this.keys = keys;
        this.value = value;
        this.accumulator = accumulator;
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return ((Map)this.factory.get()).getClass();
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Map map = (Map)this.factory.get();
        block3: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    Map.Entry entry = reader.readObject(StringKeyMapEntry.class);
                    this.accumulator.accept(map, entry);
                    continue block3;
                }
            }
            reader.skipField(tag);
        }
        return (T)map;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T map) throws IOException {
        for (String key : this.keys.apply(map)) {
            V value = this.value.apply(map, key);
            writer.writeObject(1, new StringKeyMapEntry<V>(key, value));
        }
    }
}

