/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.AbstractUtilTestCase;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.test.TestComparator;

public abstract class AbstractConcurrentTestCase {
    private static final Map<Object, Object> BASIS = Stream.of(1, 2, 3, 4, 5).collect(Collectors.toMap(i -> i, i -> Integer.toString(-i.intValue())));
    private final MarshallingTesterFactory factory;

    public AbstractConcurrentTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testConcurrentHashMap() throws IOException {
        MarshallingTester<ConcurrentHashMap> tester = this.factory.createTester();
        tester.test(new ConcurrentHashMap<Object, Object>(BASIS), AbstractConcurrentTestCase::assertMapEquals);
    }

    @Test
    public void testConcurrentHashSet() throws IOException {
        ConcurrentHashMap.KeySetView<Object, Boolean> keySetView = ConcurrentHashMap.newKeySet();
        keySetView.addAll((Collection<Object>)BASIS.keySet());
        MarshallingTester<ConcurrentHashMap.KeySetView> tester = this.factory.createTester();
        tester.test(keySetView, AbstractConcurrentTestCase::assertCollectionEquals);
    }

    @Test
    public void testConcurrentLinkedDeque() throws IOException {
        MarshallingTester<ConcurrentLinkedDeque> tester = this.factory.createTester();
        tester.test(new ConcurrentLinkedDeque<Object>(BASIS.keySet()), AbstractConcurrentTestCase::assertCollectionEquals);
    }

    @Test
    public void testConcurrentLinkedQueue() throws IOException {
        MarshallingTester<ConcurrentLinkedQueue> tester = this.factory.createTester();
        tester.test(new ConcurrentLinkedQueue<Object>(BASIS.keySet()), AbstractConcurrentTestCase::assertCollectionEquals);
    }

    @Test
    public void testConcurrentSkipListMap() throws IOException {
        MarshallingTester<ConcurrentSkipListMap> tester = this.factory.createTester();
        ConcurrentSkipListMap<Object, Object> map = new ConcurrentSkipListMap<Object, Object>();
        map.putAll(BASIS);
        tester.test(map, AbstractConcurrentTestCase::assertMapEquals);
        map = new ConcurrentSkipListMap(Comparator.reverseOrder());
        map.putAll(BASIS);
        tester.test(map, AbstractConcurrentTestCase::assertMapEquals);
        map = new ConcurrentSkipListMap(new TestComparator());
        map.putAll(BASIS);
        tester.test(map, AbstractConcurrentTestCase::assertMapEquals);
        tester.test(new ConcurrentSkipListMap<Object, Object>(BASIS), AbstractConcurrentTestCase::assertMapEquals);
    }

    @Test
    public void testConcurrentSkipListSet() throws IOException {
        MarshallingTester<ConcurrentSkipListSet> tester = this.factory.createTester();
        ConcurrentSkipListSet<Object> set = new ConcurrentSkipListSet<Object>();
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        set = new ConcurrentSkipListSet(Comparator.reverseOrder());
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
        set = new ConcurrentSkipListSet(new TestComparator());
        set.addAll(BASIS.keySet());
        tester.test(set, AbstractUtilTestCase::assertCollectionEquals);
    }

    @Test
    public void testCopyOnWriteArrayList() throws IOException {
        MarshallingTester<CopyOnWriteArrayList> tester = this.factory.createTester();
        tester.test(new CopyOnWriteArrayList<Object>(BASIS.keySet()), AbstractConcurrentTestCase::assertCollectionEquals);
    }

    @Test
    public void testCopyOnWriteArraySet() throws IOException {
        MarshallingTester<CopyOnWriteArraySet> tester = this.factory.createTester();
        tester.test(new CopyOnWriteArraySet<Object>(BASIS.keySet()), AbstractConcurrentTestCase::assertCollectionEquals);
    }

    @Test
    public void testTimeUnit() throws IOException {
        this.factory.createTester(TimeUnit.class).test();
    }

    static <T extends Map<?, ?>> void assertMapEquals(T expected, T actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Assertions.assertTrue((boolean)expected.keySet().containsAll(actual.keySet()));
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            Assertions.assertEquals(entry.getValue(), actual.get(entry.getKey()));
        }
    }

    static <T extends Collection<?>> void assertCollectionEquals(T expected, T actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Assertions.assertTrue((boolean)expected.containsAll(actual));
    }
}

