/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTester;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;

public abstract class AbstractAtomicTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractAtomicTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testAtomicBoolean() throws IOException {
        MarshallingTester<AtomicBoolean> tester = this.factory.createTester();
        tester.test(new AtomicBoolean(false), (expected, actual) -> Assertions.assertEquals((Object)expected.get(), (Object)actual.get()));
        tester.test(new AtomicBoolean(true), (expected, actual) -> Assertions.assertEquals((Object)expected.get(), (Object)actual.get()));
    }

    @Test
    public void testAtomicInteger() throws IOException {
        MarshallingTester<AtomicInteger> tester = this.factory.createTester();
        tester.test(new AtomicInteger(), (expected, actual) -> Assertions.assertEquals((int)expected.get(), (int)actual.get()));
        tester.test(new AtomicInteger(127), (expected, actual) -> Assertions.assertEquals((int)expected.get(), (int)actual.get()));
        tester.test(new AtomicInteger(Integer.MAX_VALUE), (expected, actual) -> Assertions.assertEquals((int)expected.get(), (int)actual.get()));
    }

    @Test
    public void testAtomicLong() throws IOException {
        MarshallingTester<AtomicLong> tester = this.factory.createTester();
        tester.test(new AtomicLong(), (expected, actual) -> Assertions.assertEquals((long)expected.get(), (long)actual.get()));
        tester.test(new AtomicLong(32767L), (expected, actual) -> Assertions.assertEquals((long)expected.get(), (long)actual.get()));
        tester.test(new AtomicLong(Long.MAX_VALUE), (expected, actual) -> Assertions.assertEquals((long)expected.get(), (long)actual.get()));
    }

    @Test
    public void testAtomicReference() throws IOException {
        MarshallingTester<AtomicReference> tester = this.factory.createTester();
        tester.test(new AtomicReference(), (expected, actual) -> Assertions.assertEquals(expected.get(), actual.get()));
        tester.test(new AtomicReference<Boolean>(Boolean.TRUE), (expected, actual) -> Assertions.assertEquals(expected.get(), actual.get()));
    }
}

