/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;

public abstract class ByteBufferMarshalledValueFactoryTestCase {
    private final ByteBufferMarshaller marshaller;
    private final ByteBufferMarshalledValueFactory factory;

    protected ByteBufferMarshalledValueFactoryTestCase(MarshallingTesterFactory factory) {
        this(factory.getMarshaller());
    }

    protected ByteBufferMarshalledValueFactoryTestCase(ByteBufferMarshaller marshaller) {
        this(marshaller, new ByteBufferMarshalledValueFactory(marshaller));
    }

    ByteBufferMarshalledValueFactoryTestCase(ByteBufferMarshaller marshaller, ByteBufferMarshalledValueFactory factory) {
        this.marshaller = marshaller;
        this.factory = factory;
    }

    @Test
    public void get() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assertions.assertNotNull((Object)mv.peek());
        Assertions.assertSame((Object)uuid, (Object)mv.peek());
        Assertions.assertSame((Object)uuid, (Object)mv.get(this.marshaller));
        ByteBufferMarshalledValue copy = this.replicate(mv);
        Assertions.assertNull((Object)copy.peek());
        UUID uuid2 = (UUID)copy.get(this.marshaller);
        Assertions.assertNotSame((Object)uuid, (Object)uuid2);
        Assertions.assertEquals((Object)uuid, (Object)uuid2);
        copy = this.replicate(copy);
        uuid2 = (UUID)copy.get(this.marshaller);
        Assertions.assertEquals((Object)uuid, (Object)uuid2);
        mv = this.factory.createMarshalledValue(null);
        Assertions.assertNull((Object)mv.peek());
        Assertions.assertNull((Object)mv.getBuffer());
        Assertions.assertNull((Object)mv.get(this.marshaller));
    }

    @Test
    public void equals() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assertions.assertTrue((boolean)mv.equals((Object)mv));
        Assertions.assertFalse((boolean)mv.equals(null));
        ByteBufferMarshalledValue dup = this.factory.createMarshalledValue((Object)uuid);
        Assertions.assertTrue((boolean)mv.equals((Object)dup));
        Assertions.assertTrue((boolean)dup.equals((Object)mv));
        ByteBufferMarshalledValue replica = this.replicate(mv);
        Assertions.assertTrue((boolean)mv.equals(replica));
        Assertions.assertTrue((boolean)replica.equals((Object)mv));
        ByteBufferMarshalledValue nulled = this.factory.createMarshalledValue(null);
        Assertions.assertFalse((boolean)mv.equals((Object)nulled));
        Assertions.assertFalse((boolean)nulled.equals((Object)mv));
        Assertions.assertFalse((boolean)replica.equals((Object)nulled));
        Assertions.assertFalse((boolean)nulled.equals(replica));
        Assertions.assertTrue((boolean)nulled.equals((Object)nulled));
        Assertions.assertFalse((boolean)nulled.equals(null));
        Assertions.assertTrue((boolean)nulled.equals((Object)this.factory.createMarshalledValue(null)));
    }

    @Test
    public void testHashCode() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assertions.assertEquals((int)uuid.hashCode(), (int)mv.hashCode());
        ByteBufferMarshalledValue copy = this.replicate(mv);
        Assertions.assertEquals((int)0, (int)copy.hashCode());
        mv = this.factory.createMarshalledValue(null);
        Assertions.assertEquals((int)0, (int)mv.hashCode());
    }

    <V> ByteBufferMarshalledValue<V> replicate(ByteBufferMarshalledValue<V> value) throws IOException {
        OptionalInt size = this.marshaller.size(value);
        ByteBuffer buffer = this.marshaller.write(value);
        if (size.isPresent()) {
            Assertions.assertEquals((int)size.getAsInt(), (int)buffer.remaining());
        }
        ByteBufferMarshalledValue result = (ByteBufferMarshalledValue)this.marshaller.read(buffer);
        OptionalInt resultSize = this.marshaller.size((Object)result);
        if (size.isPresent() && resultSize.isPresent()) {
            Assertions.assertEquals((int)size.getAsInt(), (int)resultSize.getAsInt());
        }
        return result;
    }
}

