/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.test.TestInvocationHandler;

public abstract class AbstractLangTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractLangTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testUnmarshallable() {
        Tester<ThreadLocal<String>> tester = this.factory.createTester();
        tester.reject(ThreadLocal.withInitial(() -> "foo"));
    }

    @Test
    public void testBoolean() {
        this.factory.createTester().accept(true);
    }

    @Test
    public void testByte() {
        Tester<Byte> tester = this.factory.createTester();
        for (int i = 0; i < 8; ++i) {
            tester.accept(Integer.valueOf((1 << i) - 1).byteValue());
            tester.accept(Integer.valueOf(-1 << i).byteValue());
        }
    }

    @Test
    public void testShort() {
        Tester<Short> tester = this.factory.createTester();
        for (int i = 0; i < 16; ++i) {
            tester.accept(Integer.valueOf((1 << i) - 1).shortValue());
            tester.accept(Integer.valueOf(-1 << i).shortValue());
        }
    }

    @Test
    public void testInteger() {
        Tester<Integer> tester = this.factory.createTester();
        for (int i = 0; i < 32; ++i) {
            tester.accept((1 << i) - 1);
            tester.accept(-1 << i);
        }
    }

    @Test
    public void testLong() {
        Tester<Long> tester = this.factory.createTester();
        for (int i = 0; i < 64; ++i) {
            tester.accept((1L << i) - 1L);
            tester.accept(-1L << i);
        }
    }

    @Test
    public void testFloat() {
        Tester<Float> tester = this.factory.createTester();
        tester.accept(Float.valueOf(Float.NEGATIVE_INFINITY));
        tester.accept(Float.valueOf(Float.MIN_VALUE));
        tester.accept(Float.valueOf(0.0f));
        tester.accept(Float.valueOf(Float.MAX_VALUE));
        tester.accept(Float.valueOf(Float.POSITIVE_INFINITY));
        tester.accept(Float.valueOf(Float.NaN));
    }

    @Test
    public void testDouble() {
        Tester<Double> tester = this.factory.createTester();
        tester.accept(Double.NEGATIVE_INFINITY);
        tester.accept((Double)Double.MIN_VALUE);
        tester.accept(0.0);
        tester.accept((Double)Double.MAX_VALUE);
        tester.accept(Double.POSITIVE_INFINITY);
        tester.accept(Double.NaN);
    }

    @Test
    public void testCharacter() {
        Tester<Character> tester = this.factory.createTester();
        tester.accept(Character.valueOf('\u0000'));
        tester.accept(Character.valueOf('A'));
        tester.accept(Character.valueOf('\uffff'));
    }

    @Test
    public void testString() {
        Tester<String> tester = this.factory.createTester();
        tester.accept("A");
        tester.accept(UUID.randomUUID().toString());
    }

    @Test
    public void testBooleanArray() {
        boolean[] array = new boolean[]{true, false};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new boolean[][]{array, array});
        Boolean[] objectArray = new Boolean[]{true, false};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Boolean[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testByteArray() {
        byte[] array = new byte[]{-128, 0, 127};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new byte[][]{array, array});
        Byte[] objectArray = new Byte[]{(byte)-128, (byte)0, (byte)127};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Byte[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testShortArray() {
        short[] array = new short[]{Short.MIN_VALUE, 0, Short.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new short[][]{array, array});
        Short[] objectArray = new Short[]{(short)Short.MIN_VALUE, (short)0, (short)Short.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Short[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testIntegerArray() {
        int[] array = new int[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new int[][]{array, array});
        Integer[] objectArray = new Integer[]{Integer.MIN_VALUE, 0, Integer.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Integer[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new long[][]{array, array});
        Long[] objectArray = new Long[]{Long.MIN_VALUE, 0L, Long.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Long[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testFloatArray() {
        float[] array = new float[]{Float.MIN_VALUE, 0.0f, Float.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new float[][]{array, array});
        Float[] objectArray = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Float[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testDoubleArray() {
        double[] array = new double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new double[][]{array, array});
        Double[] objectArray = new Double[]{Double.MIN_VALUE, 0.0, Double.MAX_VALUE};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Double[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testCharArray() {
        char[] array = new char[]{'\u0000', 'A', '\uffff'};
        this.factory.createTester(Assertions::assertArrayEquals).accept(array);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new char[][]{array, array});
        Character[] objectArray = new Character[]{Character.valueOf('\u0000'), Character.valueOf('A'), Character.valueOf('\uffff')};
        this.factory.createTester(Assertions::assertArrayEquals).accept(objectArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Character[][]{objectArray, objectArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{objectArray, objectArray});
    }

    @Test
    public void testObjectArray() {
        String string1 = "foo";
        String string2 = "bar";
        String[] stringArray = new String[]{string1, string2};
        this.factory.createTester(Assertions::assertArrayEquals).accept(stringArray);
        this.factory.createTester(Assertions::assertArrayEquals).accept(new String[]{string1, string1});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new String[][]{stringArray, stringArray});
        this.factory.createTester(Assertions::assertArrayEquals).accept(new Object[][]{stringArray, stringArray});
    }

    @Test
    public void testNull() {
        this.factory.createIdentityTester().accept(null);
    }

    @Test
    public void testClass() {
        Tester<Class> tester = this.factory.createIdentityTester();
        tester.accept(Object.class);
        tester.accept(Integer.class);
        tester.accept(Throwable.class);
        tester.accept(Exception.class);
    }

    @Test
    public void testException() {
        RuntimeException exception = new RuntimeException("foo");
        exception.setStackTrace(new StackTraceElement[]{exception.getStackTrace()[0]});
        Exception cause = new Exception("bar");
        cause.setStackTrace(new StackTraceElement[]{cause.getStackTrace()[0]});
        Error suppressed = new Error("baz");
        suppressed.setStackTrace(new StackTraceElement[]{suppressed.getStackTrace()[0]});
        exception.initCause(cause);
        exception.addSuppressed(suppressed);
        this.factory.createTester(AbstractLangTestCase::assertEquals).accept(exception);
    }

    @Test
    public void testStackTrace() {
        this.factory.createTester(AbstractLangTestCase::assertEquals).accept(new StackTraceElement("class", "method", "file", -1));
        this.factory.createTester(AbstractLangTestCase::assertEquals).accept(new StackTraceElement("loader", "module", "1.0", "class", "method", "file", 1));
    }

    @Test
    public void testProxy() {
        Object proxy = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Iterable.class}, (InvocationHandler)new TestInvocationHandler("foo"));
        this.factory.createTester(AbstractLangTestCase::assertProxyEquals).accept(proxy);
    }

    private static void assertProxyEquals(Object expected, Object actual) {
        Assertions.assertTrue((boolean)Proxy.isProxyClass(actual.getClass()));
        TestInvocationHandler actualHandler = (TestInvocationHandler)Proxy.getInvocationHandler(actual);
        TestInvocationHandler expectedHandler = (TestInvocationHandler)Proxy.getInvocationHandler(expected);
        Assertions.assertEquals((Object)expectedHandler.getValue(), (Object)actualHandler.getValue());
    }

    private static void assertEquals(Throwable expected, Throwable actual) {
        Assertions.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        StackTraceElement[] expectedStackTrace = expected.getStackTrace();
        StackTraceElement[] actualStackTrace = expected.getStackTrace();
        Assertions.assertEquals((int)expectedStackTrace.length, (int)actualStackTrace.length);
        for (int i = 0; i < expectedStackTrace.length; ++i) {
            AbstractLangTestCase.assertEquals(expectedStackTrace[i], actualStackTrace[i]);
        }
        Throwable[] expectedSuppressed = expected.getSuppressed();
        Throwable[] actualSuppressed = actual.getSuppressed();
        Assertions.assertEquals((int)expectedSuppressed.length, (int)actualSuppressed.length);
        for (int i = 0; i < expectedSuppressed.length; ++i) {
            AbstractLangTestCase.assertEquals(expectedSuppressed[i], actualSuppressed[i]);
        }
        Throwable cause1 = expected.getCause();
        Throwable cause2 = actual.getCause();
        if (cause1 != null && cause2 != null) {
            AbstractLangTestCase.assertEquals(cause1, cause2);
        } else {
            Assertions.assertSame((Object)cause1, (Object)cause2);
        }
    }

    private static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        Assertions.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        Assertions.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        Assertions.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        Assertions.assertEquals((int)expected.getLineNumber(), (int)actual.getLineNumber());
        Assertions.assertEquals((Object)expected.getClassLoaderName(), (Object)actual.getClassLoaderName());
        Assertions.assertEquals((Object)expected.getModuleName(), (Object)actual.getModuleName());
        Assertions.assertEquals((Object)expected.getModuleVersion(), (Object)actual.getModuleVersion());
    }
}

