/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Serializer;

public interface Formatter<T> {
    public static final Identity IDENTITY = new Identity(){

        @Override
        public Class<String> getTargetClass() {
            return String.class;
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public String format(String key) {
            return key;
        }
    };

    public Class<T> getTargetClass();

    public T parse(String var1);

    public String format(T var1);

    default public <U> Formatter<U> wrap(final Class<U> targetClass, final Function<T, U> wrapper, final Function<U, T> unwrapper) {
        return new Formatter<U>(){

            @Override
            public Class<U> getTargetClass() {
                return targetClass;
            }

            @Override
            public U parse(String value) {
                return wrapper.apply(Formatter.this.parse(value));
            }

            @Override
            public String format(U value) {
                return Formatter.this.format(unwrapper.apply(value));
            }
        };
    }

    public static <T> Formatter<T> of(final T value) {
        return new Formatter<T>(){

            @Override
            public Class<T> getTargetClass() {
                return value.getClass();
            }

            @Override
            public T parse(String ignored) {
                return value;
            }

            @Override
            public String format(T ignored) {
                return "";
            }
        };
    }

    public static <T> Formatter<T> serialized(final Class<T> targetClass, final Serializer<T> serializer) {
        return new Formatter<T>(){

            @Override
            public Class<T> getTargetClass() {
                return targetClass;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T parse(String value) {
                byte[] bytes = Base64.getDecoder().decode(value);
                try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));){
                    Object t = serializer.read(input);
                    return t;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public String format(T key) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try (DataOutputStream output = new DataOutputStream(bytes);){
                    serializer.write(output, key);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                return Base64.getEncoder().encodeToString(bytes.toByteArray());
            }
        };
    }

    public static interface Identity
    extends Formatter<String> {
        default public <U> Formatter<U> wrap(Class<U> targetClass, Function<String, U> wrapper) {
            return this.wrap(targetClass, wrapper, Object::toString);
        }
    }

    public static class Provided<T>
    implements Formatter<T> {
        private final Formatter<T> formatter;

        public Provided(Formatter<T> formatter) {
            this.formatter = formatter;
        }

        @Override
        public Class<T> getTargetClass() {
            return this.formatter.getTargetClass();
        }

        @Override
        public T parse(String value) {
            return this.formatter.parse(value);
        }

        @Override
        public String format(T value) {
            return this.formatter.format(value);
        }
    }
}

