/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;

public abstract class AbstractAtomicTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractAtomicTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testAtomicBoolean() {
        Tester<AtomicBoolean> tester = this.factory.createTester(AtomicBoolean::get);
        tester.accept(new AtomicBoolean(false));
        tester.accept(new AtomicBoolean(true));
    }

    @Test
    public void testAtomicInteger() {
        Tester<AtomicInteger> tester = this.factory.createTester(AtomicInteger::get);
        tester.accept(new AtomicInteger());
        tester.accept(new AtomicInteger(127));
        tester.accept(new AtomicInteger(Integer.MAX_VALUE));
    }

    @Test
    public void testAtomicLong() {
        Tester<AtomicLong> tester = this.factory.createTester(AtomicLong::get);
        tester.accept(new AtomicLong());
        tester.accept(new AtomicLong(32767L));
        tester.accept(new AtomicLong(Long.MAX_VALUE));
    }

    @Test
    public void testAtomicReference() {
        Tester<AtomicReference> tester = this.factory.createTester(AtomicReference::get);
        tester.accept(new AtomicReference());
        tester.accept(new AtomicReference<Boolean>(Boolean.TRUE));
    }
}

