/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.junit;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class TesterFactoryArgumentsProvider
extends AnnotationBasedArgumentsProvider<TesterFactorySource> {
    protected Stream<? extends Arguments> provideArguments(ExtensionContext context, TesterFactorySource annotation) {
        Stream.Builder<Arguments> builder = Stream.builder();
        for (Class<? extends TesterFactory> factoryClass : annotation.value()) {
            Iterator<? extends TesterFactory> factories = ServiceLoader.load(factoryClass, factoryClass.getClassLoader()).iterator();
            if (!factories.hasNext()) {
                throw new ServiceConfigurationError(factoryClass.getName());
            }
            while (factories.hasNext()) {
                builder.accept(Arguments.of((Object[])new Object[]{factories.next()}));
            }
        }
        return builder.build();
    }
}

