/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Random;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;

public abstract class AbstractMathTestCase {
    private final MarshallingTesterFactory factory;
    private final Random random = new Random(System.currentTimeMillis());

    public AbstractMathTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    private BigInteger probablePrime() {
        return BigInteger.probablePrime(127, this.random);
    }

    @Test
    public void testBigInteger() {
        this.testBigInteger(BigInteger.ZERO);
        this.testBigInteger(BigInteger.ONE);
        this.testBigInteger(BigInteger.TEN);
        this.testBigInteger(this.probablePrime());
    }

    private void testBigInteger(BigInteger value) {
        Tester<BigInteger> tester = this.factory.createTester();
        tester.accept(value);
        tester.accept(value.negate());
    }

    @Test
    public void testBigDecimal() {
        this.testBigDecimal(BigDecimal.ZERO);
        this.testBigDecimal(BigDecimal.ONE);
        this.testBigDecimal(BigDecimal.TEN);
        this.testBigDecimal(new BigDecimal(this.probablePrime(), Integer.MAX_VALUE));
        this.testBigDecimal(new BigDecimal(this.probablePrime(), Integer.MIN_VALUE));
    }

    private void testBigDecimal(BigDecimal value) {
        Tester<BigDecimal> tester = this.factory.createTester();
        tester.accept(value);
        tester.accept(value.negate());
    }

    @Test
    public void testMathContext() {
        Tester<MathContext> tester = this.factory.createTester();
        tester.accept(new MathContext(0));
        tester.accept(new MathContext(10, RoundingMode.UNNECESSARY));
    }

    @Test
    public void testRoundingMode() {
        this.factory.createTester(RoundingMode.class).run();
    }
}

