/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.test.TestComparator;

public abstract class AbstractUtilTestCase {
    private static final Map<Object, Object> BASIS = Stream.of(1, 2, 3, 4, 5).collect(Collectors.toMap(i -> i, i -> Integer.toString(-i.intValue())));
    private final MarshallingTesterFactory factory;

    public AbstractUtilTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testArrayDeque() {
        Tester<ArrayDeque<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(new ArrayDeque<Object>(BASIS.keySet()));
    }

    @Test
    public void testArrayList() {
        Tester<ArrayList<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(new ArrayList<Object>(BASIS.keySet()));
    }

    @Test
    public void testBitSet() {
        Tester<BitSet> tester = this.factory.createTester();
        tester.accept(new BitSet(0));
        BitSet set = new BitSet(7);
        set.set(1);
        set.set(3);
        set.set(5);
        tester.accept(set);
    }

    @Test
    public void testCalendar() {
        Tester<Calendar> tester = this.factory.createTester();
        LocalDateTime time = LocalDateTime.now();
        tester.accept(new Calendar.Builder().setDate(time.getYear(), time.getMonthValue(), time.getDayOfMonth()).build());
        tester.accept(new Calendar.Builder().setLenient(false).setLocale(Locale.FRANCE).setDate(time.getYear(), time.getMonthValue() - 1, time.getDayOfMonth()).setTimeOfDay(time.getHour(), time.getMinute(), time.getSecond()).build());
        tester.accept(new Calendar.Builder().setLocale(Locale.JAPAN).setTimeZone(TimeZone.getTimeZone("Asia/Tokyo")).setInstant(Date.from(time.toInstant(ZoneOffset.UTC))).build());
        tester.accept(new Calendar.Builder().setLocale(Locale.forLanguageTag("th_TH")).setTimeZone(TimeZone.getTimeZone("Asia/Bangkok")).build());
    }

    @Test
    public void testCurrency() {
        Tester<Currency> tester = this.factory.createTester();
        for (Currency currency : Currency.getAvailableCurrencies()) {
            tester.accept(currency);
        }
    }

    @Test
    public void testDate() {
        Tester<Date> tester = this.factory.createTester();
        tester.accept(Date.from(Instant.EPOCH));
        tester.accept(Date.from(Instant.now()));
    }

    @Test
    public void testEnumMap() {
        Tester tester = this.factory.createMapTester();
        EnumMap<Thread.State, String> map = new EnumMap<Thread.State, String>(Thread.State.class);
        tester.accept(map);
        Iterator iterator = EnumSet.allOf(Thread.State.class).iterator();
        while (iterator.hasNext()) {
            Thread.State state;
            map.put(state, (state = (Thread.State)((Object)iterator.next())).ordinal() % 2 == 0 ? state.name() : null);
            tester.accept(map);
        }
    }

    @Test
    public void testEnumSet() {
        Tester<EnumSet<Thread.State>> tester = this.factory.createCollectionTester();
        EnumSet<Thread.State> set = EnumSet.noneOf(Thread.State.class);
        tester.accept(set);
        for (Thread.State state : EnumSet.allOf(Thread.State.class)) {
            set.add(state);
            tester.accept(set);
        }
    }

    @Test
    public void testJumboEnumSet() {
        Tester<EnumSet<Object>> tester = this.factory.createCollectionTester();
        tester.accept(EnumSet.noneOf(Character.UnicodeScript.class));
        tester.accept(EnumSet.of(Character.UnicodeScript.UNKNOWN));
        tester.accept(EnumSet.of(Character.UnicodeScript.ARABIC, new Character.UnicodeScript[]{Character.UnicodeScript.ARMENIAN, Character.UnicodeScript.AVESTAN, Character.UnicodeScript.BALINESE, Character.UnicodeScript.BAMUM, Character.UnicodeScript.BATAK, Character.UnicodeScript.BENGALI, Character.UnicodeScript.BOPOMOFO, Character.UnicodeScript.BRAHMI, Character.UnicodeScript.BRAILLE, Character.UnicodeScript.BUGINESE, Character.UnicodeScript.BUHID, Character.UnicodeScript.CANADIAN_ABORIGINAL, Character.UnicodeScript.CARIAN}));
        tester.accept(EnumSet.complementOf(EnumSet.of(Character.UnicodeScript.UNKNOWN)));
        tester.accept(EnumSet.allOf(Character.UnicodeScript.class));
    }

    @Test
    public void testHashMap() {
        Tester<HashMap<Object, Object>> tester = this.factory.createMapTester();
        tester.accept(new HashMap<Object, Object>(BASIS));
    }

    @Test
    public void testHashSet() {
        Tester<HashSet<Object>> tester = this.factory.createCollectionTester();
        tester.accept(new HashSet<Object>(BASIS.keySet()));
    }

    @Test
    public void testLinkedHashMap() {
        Tester tester = this.factory.createOrderedMapTester();
        tester.accept(new LinkedHashMap<Object, Object>(BASIS));
        LinkedHashMap<Object, Object> accessOrderMap = new LinkedHashMap<Object, Object>(5, 1.0f, true);
        accessOrderMap.putAll(BASIS);
        tester.accept(new LinkedHashMap(accessOrderMap));
    }

    @Test
    public void testLinkedHashSet() {
        Tester<LinkedHashSet<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(new LinkedHashSet<Object>(BASIS.keySet()));
    }

    @Test
    public void testLinkedList() {
        Tester<LinkedList<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(new LinkedList<Object>(BASIS.keySet()));
    }

    @Test
    public void testLocale() {
        Tester<Locale> tester = this.factory.createTester();
        for (Locale locale : Locale.getAvailableLocales()) {
            tester.accept(locale);
        }
    }

    @Test
    public void testSimpleEntry() {
        Tester<AbstractMap.SimpleEntry<Object, Object>> tester = this.factory.createTester();
        String key = "key";
        String value = "value";
        tester.accept(new AbstractMap.SimpleEntry<Object, Object>(null, null));
        tester.accept(new AbstractMap.SimpleEntry<String, Object>(key, null));
        tester.accept(new AbstractMap.SimpleEntry<String, String>(key, value));
        tester.accept(new AbstractMap.SimpleEntry<String, String>(value, value));
    }

    @Test
    public void testSimpleImmutableEntry() {
        Tester<AbstractMap.SimpleImmutableEntry<Object, Object>> tester = this.factory.createTester();
        String key = "key";
        String value = "value";
        tester.accept(new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null));
        tester.accept(new AbstractMap.SimpleImmutableEntry<String, Object>(key, null));
        tester.accept(new AbstractMap.SimpleImmutableEntry<String, String>(key, value));
        tester.accept(new AbstractMap.SimpleImmutableEntry<String, String>(value, value));
    }

    @Test
    public void testTimeZone() {
        Tester<TimeZone> tester = this.factory.createTester();
        tester.accept(TimeZone.getDefault());
        tester.accept(TimeZone.getTimeZone("GMT"));
    }

    @Test
    public void testTreeMap() {
        Tester tester = this.factory.createOrderedMapTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.accept(map);
        map = new TreeMap(Comparator.reverseOrder());
        map.putAll(BASIS);
        tester.accept(map);
        map = new TreeMap(new TestComparator());
        map.putAll(BASIS);
        tester.accept(map);
    }

    @Test
    public void testTreeSet() {
        Tester tester = this.factory.createOrderedCollectionTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.accept(set);
        set = new TreeSet(Comparator.reverseOrder());
        set.addAll(BASIS.keySet());
        tester.accept(set);
        set = new TreeSet(new TestComparator());
        set.addAll(BASIS.keySet());
        tester.accept(set);
    }

    @Test
    public void testUUID() {
        Tester<UUID> tester = this.factory.createTester();
        tester.accept(UUID.randomUUID());
    }

    @Test
    public void testEmptyList() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptyList());
    }

    @Test
    public void testEmptyMap() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptyMap());
    }

    @Test
    public void testEmptyNavigableMap() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptyNavigableMap());
    }

    @Test
    public void testEmptyNavigableSet() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptyNavigableSet());
    }

    @Test
    public void testEmptySet() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptySet());
    }

    @Test
    public void testEmptySortedMap() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptySortedMap());
    }

    @Test
    public void testEmptySortedSet() {
        Tester tester = this.factory.createIdentityTester();
        tester.accept(Collections.emptySortedSet());
    }

    @Test
    public void testSynchronizedCollection() {
        Tester<Collection<Object>> tester = this.factory.createCollectionTester();
        tester.accept(Collections.synchronizedCollection(new LinkedList<Object>(BASIS.keySet())));
    }

    @Test
    public void testSynchronizedList() {
        Tester<List<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(Collections.synchronizedList(new LinkedList<Object>(BASIS.keySet())));
    }

    @Test
    public void testSynchronizedMap() {
        Tester<Map<Object, Object>> tester = this.factory.createMapTester();
        tester.accept(Collections.synchronizedMap(new HashMap<Object, Object>(BASIS)));
    }

    @Test
    public void testSynchronizedNavigableMap() {
        Tester tester = this.factory.createMapTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.accept(Collections.synchronizedNavigableMap(map));
    }

    @Test
    public void testSynchronizedNavigableSet() {
        Tester tester = this.factory.createOrderedCollectionTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.accept(Collections.synchronizedNavigableSet(set));
    }

    @Test
    public void testSynchronizedRandomAccessList() {
        Tester<List<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(Collections.synchronizedList(new ArrayList<Object>(BASIS.keySet())));
    }

    @Test
    public void testSynchronizedSet() {
        Tester<Set<Object>> tester = this.factory.createCollectionTester();
        tester.accept(Collections.synchronizedSet(new HashSet<Object>(BASIS.keySet())));
    }

    @Test
    public void testSynchronizedSortedMap() {
        Tester tester = this.factory.createTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.accept(Collections.synchronizedSortedMap(map));
    }

    @Test
    public void testSynchronizedSortedSet() {
        Tester tester = this.factory.createOrderedCollectionTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.accept(Collections.synchronizedSortedSet(set));
    }

    @Test
    public void testSingletonList() {
        Tester<List<Object>> tester = this.factory.createOrderedCollectionTester();
        tester.accept(Collections.singletonList(null));
        tester.accept(Collections.singletonList("foo"));
    }

    @Test
    public void testSingletonMap() {
        Tester<Map<Object, Object>> tester = this.factory.createMapTester();
        tester.accept(Collections.singletonMap(null, null));
        tester.accept(Collections.singletonMap("foo", null));
        tester.accept(Collections.singletonMap("foo", "bar"));
    }

    @Test
    public void testSingletonSet() {
        Tester<Set<Object>> tester = this.factory.createCollectionTester();
        tester.accept(Collections.singleton(null));
        tester.accept(Collections.singleton("foo"));
    }

    @Test
    public void testUnmodifiableCollection() {
        Tester<Collection<Object>> tester = this.factory.createCollectionTester();
        tester.accept(Collections.unmodifiableCollection(new LinkedList<Object>(BASIS.keySet())));
    }

    @Test
    public void testUnmodifiableList() {
        Tester tester = this.factory.createOrderedCollectionTester();
        tester.accept(Collections.unmodifiableList(new LinkedList<Object>(BASIS.keySet())));
        tester.accept(List.of());
        tester.accept(List.of(Integer.valueOf(0)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)));
        tester.accept(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9)));
        tester.accept(List.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
    }

    @Test
    public void testUnmodifiableMap() {
        Tester tester = this.factory.createMapTester();
        tester.accept(Collections.unmodifiableMap(new HashMap<Object, Object>(BASIS)));
        tester.accept(Map.of());
        tester.accept(Map.of(0, "0"));
        tester.accept(Map.of(0, "0", 1, "1"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8"));
        tester.accept(Map.of(0, "0", 1, "1", 2, "2", 3, "3", 4, "4", 5, "5", 6, "6", 7, "7", 8, "8", 9, "9"));
        tester.accept(Map.ofEntries(Map.entry(0, "1")));
        tester.accept(Map.ofEntries(Map.entry(0, "0"), Map.entry(1, "1")));
        tester.accept(Map.ofEntries(Map.entry(0, "0"), Map.entry(1, "1"), Map.entry(2, "2")));
    }

    @Test
    public void testUnmodifiableNavigableMap() {
        Tester tester = this.factory.createOrderedMapTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.accept(Collections.unmodifiableNavigableMap(map));
    }

    @Test
    public void testUnmodifiableNavigableSet() {
        Tester tester = this.factory.createOrderedCollectionTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.accept(Collections.unmodifiableNavigableSet(set));
    }

    @Test
    public void testUnmodifiableSet() {
        Tester tester = this.factory.createCollectionTester();
        tester.accept(Collections.unmodifiableSet(new HashSet<Object>(BASIS.keySet())));
        tester.accept(Set.of());
        tester.accept(Set.of(Integer.valueOf(0)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8)));
        tester.accept(Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9)));
        tester.accept(Set.of(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10));
    }

    @Test
    public void testUnmodifiableSortedMap() {
        Tester tester = this.factory.createOrderedMapTester();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        map.putAll(BASIS);
        tester.accept(Collections.unmodifiableSortedMap(map));
    }

    @Test
    public void testUnmodifiableSortedSet() {
        Tester tester = this.factory.createOrderedCollectionTester();
        TreeSet<Object> set = new TreeSet<Object>();
        set.addAll(BASIS.keySet());
        tester.accept(Collections.unmodifiableSortedSet(set));
    }

    static <T extends Collection<?>> void assertCollectionEquals(T expected, T actual) {
        Assertions.assertSame(expected.getClass(), actual.getClass());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Assertions.assertTrue((boolean)expected.containsAll(actual));
    }

    static <T extends Map<?, ?>> void assertMapEquals(T expected, T actual) {
        Assertions.assertSame(expected.getClass(), actual.getClass());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Assertions.assertTrue((boolean)expected.keySet().containsAll(actual.keySet()), actual.keySet()::toString);
        for (Map.Entry<?, ?> entry : expected.entrySet()) {
            Assertions.assertEquals(entry.getValue(), actual.get(entry.getKey()));
        }
    }

    static <T extends Map<?, ?>> void assertLinkedMapEquals(T expected, T actual) {
        Assertions.assertSame(expected.getClass(), actual.getClass());
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        expected.get(expected.keySet().iterator().next());
        actual.get(actual.keySet().iterator().next());
        Iterator<Map.Entry<?, ?>> expectedEntries = expected.entrySet().iterator();
        Iterator<Map.Entry<?, ?>> actualEntries = actual.entrySet().iterator();
        while (expectedEntries.hasNext() && actualEntries.hasNext()) {
            Map.Entry<?, ?> expectedEntry = expectedEntries.next();
            Map.Entry<?, ?> actualEntry = actualEntries.next();
            Assertions.assertEquals(expectedEntry.getKey(), actualEntry.getKey());
            Assertions.assertEquals(expectedEntry.getValue(), actualEntry.getValue());
        }
    }
}

