/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.IndexSerializer;
import org.wildfly.clustering.marshalling.IntSerializer;

public class IndexSerializerTestCase {
    @Test
    public void test() throws IOException {
        for (int i = 0; i < 30; ++i) {
            int index = 2 << i;
            IndexSerializerTestCase.test(index - 1);
            IndexSerializerTestCase.test(index);
        }
        IndexSerializerTestCase.test(Integer.MAX_VALUE);
    }

    private static void test(int index) throws IOException {
        IntStream.Builder builder = IntStream.builder();
        try {
            builder.add(IndexSerializerTestCase.size((IntSerializer)IndexSerializer.UNSIGNED_BYTE, index));
        }
        catch (IndexOutOfBoundsException e) {
            Assertions.assertThat((int)index).isGreaterThan(255);
        }
        try {
            builder.add(IndexSerializerTestCase.size((IntSerializer)IndexSerializer.UNSIGNED_SHORT, index));
        }
        catch (IndexOutOfBoundsException e) {
            Assertions.assertThat((int)index).isGreaterThan(65535);
        }
        builder.add(IndexSerializerTestCase.size((IntSerializer)IndexSerializer.VARIABLE, index));
        builder.add(IndexSerializerTestCase.size((IntSerializer)IndexSerializer.INTEGER, index));
        Assertions.assertThat((int)IndexSerializerTestCase.size(IndexSerializer.select((int)index), index)).isEqualTo(builder.build().min().getAsInt());
    }

    public static int size(IntSerializer externalizer, int index) throws IOException {
        ByteArrayOutputStream externalizedOutput = new ByteArrayOutputStream();
        try (DataOutputStream output = new DataOutputStream(externalizedOutput);){
            externalizer.writeInt((DataOutput)output, index);
        }
        byte[] externalizedBytes = externalizedOutput.toByteArray();
        try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(externalizedBytes));){
            Assertions.assertThat((int)externalizer.readInt((DataInput)input)).isEqualTo(index);
        }
        return externalizedBytes.length;
    }
}

