/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AtomicBooleanAssert;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;

public abstract class AbstractAtomicTestCase {
    private final MarshallingTesterFactory factory;

    public AbstractAtomicTestCase(MarshallingTesterFactory factory) {
        this.factory = factory;
    }

    @Test
    public void testAtomicBoolean() {
        Tester<AtomicBoolean> tester = this.factory.createTester(AtomicBooleanAssert::new, (assertion, expected) -> {
            if (expected.get()) {
                assertion.isTrue();
            } else {
                assertion.isFalse();
            }
        });
        tester.accept(new AtomicBoolean(false));
        tester.accept(new AtomicBoolean(true));
    }

    @Test
    public void testAtomicInteger() {
        Tester<AtomicInteger> tester = this.factory.createTester((expected, actual) -> Assertions.assertThat((AtomicInteger)actual).hasValue(expected.get()));
        tester.accept(new AtomicInteger());
        tester.accept(new AtomicInteger(127));
        tester.accept(new AtomicInteger(Integer.MAX_VALUE));
    }

    @Test
    public void testAtomicLong() {
        Tester<AtomicLong> tester = this.factory.createTester((expected, actual) -> Assertions.assertThat((AtomicLong)actual).hasValue(expected.get()));
        tester.accept(new AtomicLong());
        tester.accept(new AtomicLong(32767L));
        tester.accept(new AtomicLong(Long.MAX_VALUE));
    }

    @Test
    public void testAtomicReference() {
        Tester<AtomicReference> tester = this.factory.createTester((expected, actual) -> Assertions.assertThat((AtomicReference)actual).hasValue(expected.get()));
        tester.accept(new AtomicReference());
        tester.accept(new AtomicReference<Boolean>(Boolean.TRUE));
    }
}

