/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import java.util.UUID;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValue;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;

public abstract class ByteBufferMarshalledValueFactoryTestCase {
    private final ByteBufferMarshaller marshaller;
    private final ByteBufferMarshalledValueFactory factory;

    protected ByteBufferMarshalledValueFactoryTestCase(MarshallingTesterFactory factory) {
        this(factory.getMarshaller());
    }

    protected ByteBufferMarshalledValueFactoryTestCase(ByteBufferMarshaller marshaller) {
        this(marshaller, new ByteBufferMarshalledValueFactory(marshaller));
    }

    ByteBufferMarshalledValueFactoryTestCase(ByteBufferMarshaller marshaller, ByteBufferMarshalledValueFactory factory) {
        this.marshaller = marshaller;
        this.factory = factory;
    }

    @Test
    public void get() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((UUID)mv.peek())).isNotNull()).isSameAs((Object)uuid);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((UUID)mv.get(this.marshaller))).isNotNull()).isSameAs((Object)uuid);
        ByteBufferMarshalledValue copy = this.replicate(mv);
        Assertions.assertThat(copy).isNotNull();
        Assertions.assertThat((Comparable)((UUID)copy.peek())).isNull();
        UUID uuid2 = (UUID)copy.get(this.marshaller);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)uuid2).isNotSameAs((Object)uuid)).isEqualTo((Object)uuid);
        copy = this.replicate(copy);
        uuid2 = (UUID)copy.get(this.marshaller);
        Assertions.assertThat((Comparable)uuid2).isEqualTo((Object)uuid);
        mv = this.factory.createMarshalledValue(null);
        Assertions.assertThat((Object)mv).isNotNull();
        Assertions.assertThat((Comparable)((UUID)mv.peek())).isNull();
        Assertions.assertThat((Comparable)mv.getBuffer()).isNull();
        Assertions.assertThat((Comparable)((UUID)mv.get(this.marshaller))).isNull();
    }

    @Test
    public void equals() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        ((ObjectAssert)Assertions.assertThat((Object)mv).isNotNull()).isEqualTo((Object)mv);
        ByteBufferMarshalledValue dup = this.factory.createMarshalledValue((Object)uuid);
        Assertions.assertThat((Object)dup).isEqualTo((Object)mv);
        Assertions.assertThat((Object)mv).isEqualTo((Object)dup);
        ByteBufferMarshalledValue replica = this.replicate(mv);
        Assertions.assertThat(replica).isEqualTo((Object)mv);
        Assertions.assertThat((Object)mv).isEqualTo(replica);
        ByteBufferMarshalledValue nulled = this.factory.createMarshalledValue(null);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)nulled).isNotNull()).isNotEqualTo((Object)mv)).isNotEqualTo(replica)).isEqualTo((Object)nulled);
        Assertions.assertThat((Object)mv).isNotEqualTo((Object)nulled);
        Assertions.assertThat(replica).isNotEqualTo((Object)nulled);
        Assertions.assertThat((Object)this.factory.createMarshalledValue(null)).isEqualTo((Object)nulled);
    }

    @Test
    public void testHashCode() throws Exception {
        UUID uuid = UUID.randomUUID();
        ByteBufferMarshalledValue mv = this.factory.createMarshalledValue((Object)uuid);
        Assertions.assertThat((Object)mv).hasSameHashCodeAs((Object)uuid);
        ByteBufferMarshalledValue copy = this.replicate(mv);
        Assertions.assertThat((int)copy.hashCode()).isEqualTo(0);
        mv = this.factory.createMarshalledValue(null);
        Assertions.assertThat((int)mv.hashCode()).isEqualTo(0);
    }

    <V> ByteBufferMarshalledValue<V> replicate(ByteBufferMarshalledValue<V> value) throws IOException {
        OptionalInt size = this.marshaller.size(value);
        ByteBuffer buffer = this.marshaller.write(value);
        if (size.isPresent()) {
            Assertions.assertThat((OptionalInt)size).hasValue(buffer.remaining());
        }
        ByteBufferMarshalledValue result = (ByteBufferMarshalledValue)this.marshaller.read(buffer);
        OptionalInt resultSize = this.marshaller.size((Object)result);
        if (size.isPresent() && resultSize.isPresent()) {
            Assertions.assertThat((OptionalInt)resultSize).isEqualTo((Object)size);
        }
        return result;
    }
}

