/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Object2DArrayAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.wildfly.clustering.marshalling.Tester;

public interface TesterFactory {
    default public <A extends Assert<A, T>, T> Tester<T> createTester(final Function<T, A> assertFactory, final BiConsumer<A, T> assertion) {
        return this.createTester(new BiConsumer<T, T>(){

            @Override
            public void accept(T expected, T actual) {
                assertion.accept((Assert)assertFactory.apply(actual), expected);
            }
        });
    }

    public <T> Tester<T> createTester(BiConsumer<T, T> var1);

    default public <T> Tester<T> createTester() {
        return this.createTester(Assertions::assertThat, Assert::isEqualTo);
    }

    default public <T> Tester<T> createIdentityTester() {
        return this.createTester(Assertions::assertThat, Assert::isSameAs);
    }

    default public <T> Tester<T> createKeyTester() {
        BiConsumer<ObjectAssert, Object> assertHashCode = Assert::hasSameHashCodeAs;
        return this.createTester(Assertions::assertThat, assertHashCode.andThen(Assert::isEqualTo));
    }

    default public <E extends Enum<E>> Runnable createTester(Class<E> enumClass) {
        Tester tester = this.createIdentityTester();
        return () -> EnumSet.allOf(enumClass).forEach(tester::accept);
    }

    default public <E> Tester<E[]> createArrayTester() {
        Function<Object[], ObjectArrayAssert> arrayFactory = ObjectArrayAssert::new;
        return this.createTester(arrayFactory, AbstractObjectArrayAssert::containsExactly);
    }

    default public <E> Tester<E[][]> create2DArrayTester() {
        Function<Object[][], Object2DArrayAssert> arrayFactory = Object2DArrayAssert::new;
        return this.createTester(arrayFactory, Object2DArrayAssert::isDeepEqualTo);
    }

    default public <E, T extends Collection<E>> Tester<T> createCollectionTester() {
        return this.createTester(new BiConsumer<T, T>(){

            @Override
            public void accept(T expected, T actual) {
                Assertions.assertThat(actual).containsExactlyInAnyOrderElementsOf(expected);
            }
        });
    }

    default public <E, T extends Collection<E>> Tester<T> createOrderedCollectionTester() {
        return this.createTester(new BiConsumer<T, T>(){

            @Override
            public void accept(T expected, T actual) {
                Assertions.assertThat(actual).containsExactlyElementsOf(expected);
            }
        });
    }

    default public <K, V, T extends Map<K, V>> Tester<T> createMapTester() {
        return this.createTester(new BiConsumer<T, T>(){

            @Override
            public void accept(T expected, T actual) {
                Assertions.assertThat(actual).containsExactlyInAnyOrderEntriesOf(expected);
            }
        });
    }

    default public <K, V, T extends Map<K, V>> Tester<T> createOrderedMapTester() {
        return this.createTester(new BiConsumer<T, T>(){

            @Override
            public void accept(T expected, T actual) {
                Assertions.assertThat(actual).containsExactlyEntriesOf(expected);
            }
        });
    }
}

