/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.affinity;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.group.GroupMemberFactory;
import org.wildfly.clustering.server.infinispan.affinity.GroupMemberAffinityConfiguration;

public class NaryGroupMemberAffinity<I, M extends GroupMember<Address>>
implements Function<I, List<M>> {
    private final KeyDistribution distribution;
    private final GroupMemberFactory<Address, M> factory;
    private final M localMember;

    public NaryGroupMemberAffinity(GroupMemberAffinityConfiguration<I, M> configuration) {
        this(configuration.getCache(), configuration.getGroup());
    }

    public NaryGroupMemberAffinity(Cache<? extends CacheKey<I>, ?> cache, Group<Address, M> group) {
        this(KeyDistribution.forCache(cache), group.getGroupMemberFactory(), (GroupMember)group.getLocalMember());
    }

    NaryGroupMemberAffinity(KeyDistribution distribution, GroupMemberFactory<Address, M> factory, M localMember) {
        this.distribution = distribution;
        this.factory = factory;
        this.localMember = localMember;
    }

    @Override
    public List<M> apply(I id) {
        LinkedList<Object> members = new LinkedList<Object>();
        boolean locallyOwned = false;
        for (Address address : this.distribution.getOwners((Object)new CacheKey(id))) {
            locallyOwned |= ((Address)this.localMember.getAddress()).equals((Object)address);
            members.add(this.factory.createGroupMember((Comparable)address));
        }
        if (!locallyOwned) {
            members.add(this.localMember);
        }
        return members;
    }
}

