/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.affinity;

import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.infinispan.CacheKey;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.KeyDistribution;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.group.GroupMember;
import org.wildfly.clustering.server.group.GroupMemberFactory;
import org.wildfly.clustering.server.infinispan.affinity.GroupMemberAffinityConfiguration;

public class UnaryGroupMemberAffinity<I, M extends GroupMember<Address>>
implements Function<I, M> {
    private final KeyDistribution distribution;
    private final GroupMemberFactory<Address, M> factory;

    public UnaryGroupMemberAffinity(GroupMemberAffinityConfiguration<I, M> configuration) {
        this(configuration.getCache(), configuration.getGroup());
    }

    public UnaryGroupMemberAffinity(Cache<? extends CacheKey<I>, ?> cache, Group<Address, M> group) {
        this(KeyDistribution.forCache(cache), group.getGroupMemberFactory());
    }

    UnaryGroupMemberAffinity(KeyDistribution distribution, GroupMemberFactory<Address, M> factory) {
        this.distribution = distribution;
        this.factory = factory;
    }

    @Override
    public M apply(I id) {
        GroupMember member = null;
        while (member == null) {
            Address address = this.distribution.getPrimaryOwner((Object)new CacheKey(id));
            if (address != null) {
                member = this.factory.createGroupMember((Comparable)address);
                continue;
            }
            Thread.yield();
        }
        return (M)member;
    }
}

