/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.dispatcher;

import java.util.function.Function;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.server.group.GroupCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactory;
import org.wildfly.clustering.server.infinispan.dispatcher.EmbeddedCacheManagerCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ForkChannelFactory;
import org.wildfly.clustering.server.jgroups.dispatcher.ChannelCommandDispatcherFactoryProvider;
import org.wildfly.clustering.server.jgroups.dispatcher.CommandDispatcherFactoryProvider;

public class CacheContainerCommandDispatcherFactoryProvider
implements CommandDispatcherFactoryProvider<CacheContainerGroupMember> {
    private static final String CONTAINER_NAME = "container";
    private final ChannelCommandDispatcherFactoryProvider config;
    private final EmbeddedCacheManager manager;
    private final CommandDispatcherFactory<CacheContainerGroupMember> factory;

    public CacheContainerCommandDispatcherFactoryProvider(String clusterName, String memberName) throws Exception {
        this.config = new ChannelCommandDispatcherFactoryProvider(clusterName, memberName);
        this.manager = new EmbeddedCacheManagerFactory((Function<String, JChannel>)new ForkChannelFactory(this.config.getChannel()), clusterName, memberName).apply(CONTAINER_NAME, EmbeddedCacheManagerCommandDispatcherFactory.class.getClassLoader());
        this.factory = new EmbeddedCacheManagerCommandDispatcherFactory((EmbeddedCacheManagerCommandDispatcherFactoryConfiguration)new ChannelEmbeddedCacheManagerCommandDispatcherFactoryConfiguration(){

            public EmbeddedCacheManager getCacheContainer() {
                return CacheContainerCommandDispatcherFactoryProvider.this.manager;
            }

            public GroupCommandDispatcherFactory<Address, ChannelGroupMember> getCommandDispatcherFactory() {
                return CacheContainerCommandDispatcherFactoryProvider.this.config.getCommandDispatcherFactory();
            }
        });
    }

    public CommandDispatcherFactory<CacheContainerGroupMember> getCommandDispatcherFactory() {
        return this.factory;
    }

    public void close() throws Exception {
        this.manager.close();
        this.config.close();
    }
}

