/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.util.function.Function;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jgroups.JChannel;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.group.Group;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.ChannelEmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerFactory;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroup;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.jgroups.ChannelGroup;
import org.wildfly.clustering.server.jgroups.ChannelGroupMember;
import org.wildfly.clustering.server.jgroups.ForkChannelFactory;
import org.wildfly.clustering.server.jgroups.GroupProvider;
import org.wildfly.clustering.server.jgroups.JChannelFactory;
import org.wildfly.clustering.server.jgroups.JChannelGroup;

public class CacheContainerGroupProvider
extends AutoCloseableProvider
implements GroupProvider<Address, CacheContainerGroupMember> {
    private static final String CONTAINER_NAME = "container";
    private final JChannel channel;
    private final CacheContainerGroup group;

    public CacheContainerGroupProvider(String clusterName, String memberName) throws Exception {
        this.channel = JChannelFactory.INSTANCE.apply(memberName);
        this.accept(() -> ((JChannel)this.channel).close());
        this.channel.connect(clusterName);
        this.accept(() -> ((JChannel)this.channel).disconnect());
        JChannelGroup channelGroup = new JChannelGroup(this.channel);
        this.accept(() -> ((ChannelGroup)channelGroup).close());
        EmbeddedCacheManager manager = new EmbeddedCacheManagerFactory((Function<String, JChannel>)new ForkChannelFactory(this.channel), clusterName, memberName).apply(CONTAINER_NAME, EmbeddedCacheManagerGroup.class.getClassLoader());
        manager.start();
        this.accept(() -> ((EmbeddedCacheManager)manager).stop());
        this.group = new EmbeddedCacheManagerGroup((EmbeddedCacheManagerGroupConfiguration)new ChannelEmbeddedCacheManagerGroupConfiguration(){
            final /* synthetic */ ChannelGroup val$channelGroup;
            final /* synthetic */ EmbeddedCacheManager val$manager;
            {
                this.val$channelGroup = channelGroup;
                this.val$manager = embeddedCacheManager;
            }

            public Group<org.jgroups.Address, ChannelGroupMember> getGroup() {
                return this.val$channelGroup;
            }

            public EmbeddedCacheManager getCacheContainer() {
                return this.val$manager;
            }
        });
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public Group<Address, CacheContainerGroupMember> getGroup() {
        return this.group;
    }

    public String getName() {
        return CONTAINER_NAME;
    }
}

