/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;
import org.wildfly.clustering.server.GroupMember;
import org.wildfly.clustering.server.dispatcher.Command;
import org.wildfly.clustering.server.dispatcher.CommandDispatcher;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.server.infinispan.scheduler.CancelCommand;
import org.wildfly.clustering.server.infinispan.scheduler.ContainsCommand;
import org.wildfly.clustering.server.infinispan.scheduler.EntriesCommand;
import org.wildfly.clustering.server.infinispan.scheduler.PrimaryOwnerSchedulerConfiguration;
import org.wildfly.clustering.server.infinispan.scheduler.ScheduleCommand;
import org.wildfly.clustering.server.scheduler.Scheduler;
import org.wildfly.clustering.server.util.Invoker;
import org.wildfly.common.function.ExceptionSupplier;

public class PrimaryOwnerScheduler<I, M, GM extends org.wildfly.clustering.server.group.GroupMember<Address>>
implements Scheduler<I, M>,
Function<CompletionStage<Collection<I>>, Stream<I>> {
    private static final Logger LOGGER = Logger.getLogger(PrimaryOwnerScheduler.class);
    private final String name;
    private final Function<I, GM> affinity;
    private final CommandDispatcher<GM, CacheEntryScheduler<I, M>> dispatcher;
    private final BiFunction<I, M, ScheduleCommand<I, M>> scheduleCommandFactory;
    private final Invoker invoker;

    public PrimaryOwnerScheduler(PrimaryOwnerSchedulerConfiguration<I, M, GM> configuration) {
        this.name = configuration.getName();
        this.scheduleCommandFactory = configuration.getScheduleCommandFactory();
        this.affinity = configuration.getAffinity();
        this.invoker = configuration.getInvoker();
        CacheEntryScheduler<I, M> scheduler = configuration.getScheduler();
        this.dispatcher = configuration.getCommandDispatcherFactory().createCommandDispatcher((Object)this.name, scheduler, scheduler.getClass().getClassLoader());
    }

    public void schedule(I id, M metaData) {
        try {
            this.executeOnPrimaryOwner(id, (Command)this.scheduleCommandFactory.apply(id, metaData));
        }
        catch (IOException e) {
            LOGGER.warn((Object)id.toString(), (Throwable)e);
        }
    }

    public void cancel(I id) {
        try {
            this.executeOnPrimaryOwner(id, new CancelCommand(id)).toCompletableFuture().join();
        }
        catch (IOException | CompletionException e) {
            LOGGER.warn((Object)id.toString(), (Throwable)e);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public boolean contains(I id) {
        try {
            return (Boolean)this.executeOnPrimaryOwner(id, new ContainsCommand(id)).toCompletableFuture().join();
        }
        catch (IOException | CompletionException e) {
            LOGGER.warn((Object)id.toString(), (Throwable)e);
            return false;
        }
        catch (CancellationException e) {
            return false;
        }
    }

    private <R> CompletionStage<R> executeOnPrimaryOwner(final I id, final Command<R, CacheEntryScheduler<I, M>, RuntimeException> command) throws IOException {
        final String name = this.name;
        final Function<I, GM> affinity = this.affinity;
        final CommandDispatcher<GM, CacheEntryScheduler<I, M>> dispatcher = this.dispatcher;
        ExceptionSupplier action = new ExceptionSupplier<CompletionStage<R>, IOException>(){

            public CompletionStage<R> get() throws IOException {
                org.wildfly.clustering.server.group.GroupMember primaryOwner = (org.wildfly.clustering.server.group.GroupMember)affinity.apply(id);
                LOGGER.tracef("Executing command %s on %s via %s primary-owner scheduler", (Object)command, (Object)primaryOwner, (Object)name);
                return dispatcher.dispatchToMember(command, (GroupMember)primaryOwner);
            }
        };
        return (CompletionStage)this.invoker.invoke(action);
    }

    public Stream<I> stream() {
        try {
            Map results = this.dispatcher.dispatchToGroup(new EntriesCommand());
            return results.isEmpty() ? Stream.empty() : results.values().stream().map(this).flatMap(Function.identity()).distinct();
        }
        catch (IOException e) {
            return Stream.empty();
        }
    }

    @Override
    public Stream<I> apply(CompletionStage<Collection<I>> stage) {
        try {
            return stage.toCompletableFuture().join().stream();
        }
        catch (CompletionException e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return Stream.empty();
        }
        catch (CancellationException e) {
            return Stream.empty();
        }
    }

    public void close() {
        LOGGER.tracef("Closing command dispatcher for %s primary-owner scheduler", (Object)this.name);
        this.dispatcher.close();
        ((CacheEntryScheduler)this.dispatcher.getContext()).close();
    }
}

