/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.server.AutoCloseableProvider;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupProvider;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupProvider;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistry;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistry;
import org.wildfly.clustering.server.infinispan.provider.CacheServiceProviderRegistryConfiguration;

public class CacheContainerServiceProviderRegistryProvider<T>
extends AutoCloseableProvider
implements Supplier<CacheContainerServiceProviderRegistry<T>> {
    private static final String CACHE_NAME = "registry";
    private final CacheServiceProviderRegistry<T> registry;

    public CacheContainerServiceProviderRegistryProvider(String clusterName, String memberName) throws Exception {
        final EmbeddedCacheManagerGroupProvider provider = new EmbeddedCacheManagerGroupProvider(clusterName, memberName);
        this.accept(() -> ((CacheContainerGroupProvider)provider).close());
        EmbeddedCacheManager manager = provider.getCacheManager();
        manager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).build());
        this.accept(() -> manager.undefineConfiguration(CACHE_NAME));
        final Cache cache = manager.getCache(CACHE_NAME);
        cache.start();
        this.accept(() -> ((Cache)cache).stop());
        this.registry = new CacheServiceProviderRegistry(new CacheServiceProviderRegistryConfiguration(){

            public <K, V> Cache<K, V> getCache() {
                return cache;
            }

            public Object getId() {
                return CacheContainerServiceProviderRegistryProvider.CACHE_NAME;
            }

            public CacheContainerGroup getGroup() {
                return provider.getGroup();
            }
        });
        this.accept(() -> this.registry.close());
    }

    @Override
    public CacheContainerServiceProviderRegistry<T> get() {
        return this.registry;
    }
}

