/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.registry;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.registry.CacheContainerRegistry;
import org.wildfly.clustering.server.registry.RegistryFactory;

public interface CacheContainerRegistryFactory<K, V>
extends RegistryFactory<CacheContainerGroupMember, K, V> {
    public CacheContainerRegistry<K, V> createRegistry(Map.Entry<K, V> var1);

    public static <K, V> CacheContainerRegistryFactory<K, V> singleton(final BiFunction<Map.Entry<K, V>, Runnable, CacheContainerRegistry<K, V>> factory) {
        final AtomicReference reference = new AtomicReference();
        return new CacheContainerRegistryFactory<K, V>(){

            @Override
            public CacheContainerRegistry<K, V> createRegistry(Map.Entry<K, V> entry) {
                if (!reference.compareAndSet(null, entry)) {
                    throw new IllegalStateException();
                }
                return (CacheContainerRegistry)factory.apply(entry, () -> reference.set(null));
            }
        };
    }
}

