/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan;

import java.io.IOException;
import java.util.List;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroup;
import org.wildfly.clustering.server.infinispan.EmbeddedCacheManagerGroupConfiguration;
import org.wildfly.clustering.server.infinispan.LocalEmbeddedCacheManagerGroupConfiguration;

public class LocalGroupTestCase {
    private static final String GROUP_NAME = "group";
    private static final String MEMBER_NAME = "member";

    @Test
    public void test() throws IOException {
        GlobalConfiguration global = new GlobalConfigurationBuilder().nonClusteredDefault().cacheManagerName(GROUP_NAME).serialization().marshaller((Marshaller)IdentityMarshaller.INSTANCE).addContextInitializer(new SerializationContextInitializer(){

            @Deprecated
            public String getProtoFile() {
                return null;
            }

            @Deprecated
            public String getProtoFileName() {
                return null;
            }

            public void registerMarshallers(SerializationContext context) {
            }

            public void registerSchema(SerializationContext context) {
            }
        }).transport().nodeName(MEMBER_NAME).build();
        try (DefaultCacheManager manager = new DefaultCacheManager(global, true);){
            LocalEmbeddedCacheManagerGroupConfiguration config = () -> LocalGroupTestCase.lambda$test$0((EmbeddedCacheManager)manager);
            EmbeddedCacheManagerGroup group = new EmbeddedCacheManagerGroup((EmbeddedCacheManagerGroupConfiguration)config);
            Assertions.assertSame((Object)GROUP_NAME, (Object)group.getName());
            Assertions.assertSame((Object)MEMBER_NAME, (Object)((CacheContainerGroupMember)group.getLocalMember()).getName());
            Assertions.assertEquals(List.of((CacheContainerGroupMember)group.getLocalMember()), (Object)group.getMembership().getMembers());
            Assertions.assertSame((Object)group.getLocalMember(), (Object)group.getMembership().getCoordinator());
        }
    }

    private static /* synthetic */ EmbeddedCacheManager lambda$test$0(EmbeddedCacheManager manager) {
        return manager;
    }
}

